/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;
import org.wicketstuff.openlayers3.api.util.HeaderUtils;

public abstract class ClickHandler
extends AbstractDefaultAjaxBehavior {
    public static final String DEFAULT_PROJECTION = "EPSG:4326";
    private static Long counter = 0L;
    private final String projection;

    public ClickHandler() {
        this(DEFAULT_PROJECTION);
    }

    public ClickHandler(String projection) {
        this.projection = projection;
    }

    public abstract void handleClick(AjaxRequestTarget var1, LongLat var2);

    protected void respond(AjaxRequestTarget target) {
        String[] coordinates = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("coordinate").toString().split(",");
        Double longitude = Double.parseDouble(coordinates[0]);
        Double latitude = Double.parseDouble(coordinates[1]);
        this.handleClick(target, new LongLat(longitude, latitude, this.projection));
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("callbackUrl", this.getCallbackUrl());
        params.put("componentId", component.getMarkupId());
        Long l = counter;
        Long l2 = counter = Long.valueOf(counter + 1L);
        params.put("clickHandlerId", l.toString());
        params.put("projection", this.projection != null ? this.projection : "NULL");
        HeaderUtils.renderOnDomReady(response, ClickHandler.class, "ClickHandler.js", params);
    }
}

