/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.openlayers3.api.Feature;
import org.wicketstuff.openlayers3.api.coordinate.LongLat;
import org.wicketstuff.openlayers3.api.util.HeaderUtils;

public abstract class FeatureChangeListener
extends AbstractDefaultAjaxBehavior {
    public static final String DEFAULT_PROJECTION = "EPSG:4326";
    public static Long counter = 0L;
    private final String projection;
    private final Feature feature;

    public FeatureChangeListener(Feature feature) {
        this(DEFAULT_PROJECTION, feature);
    }

    public FeatureChangeListener(String projection, Feature feature) {
        this.projection = projection;
        this.feature = feature;
    }

    public abstract void handleChange(AjaxRequestTarget var1, String var2, LongLat var3, JsonObject var4);

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String coordinateRaw = params.getParameterValue("coordinate").toString();
        String featureId = params.getParameterValue("id").toString();
        String properties = params.getParameterValue("properties").toString();
        JsonObject propertiesJson = null;
        JsonElement propertiesParsed = new JsonParser().parse(properties);
        if (!(propertiesParsed instanceof JsonNull)) {
            propertiesJson = propertiesParsed.getAsJsonObject();
        }
        String[] coordinates = Strings.split((String)coordinateRaw, (char)',');
        Double longitude = Double.parseDouble(coordinates[0]);
        Double latitude = Double.parseDouble(coordinates[1]);
        this.handleChange(target, featureId, new LongLat(longitude, latitude, this.projection), propertiesJson);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("callbackUrl", this.getCallbackUrl());
        Long l = counter;
        Long l2 = counter = Long.valueOf(counter + 1L);
        params.put("changeHandlerId", l.toString());
        params.put("componentId", component.getMarkupId());
        params.put("featureId", this.feature.getJsId());
        params.put("projection", this.projection != null ? this.projection : "NULL");
        HeaderUtils.renderOnDomReady(response, FeatureChangeListener.class, "FeatureChangeListener.js", params);
    }
}

