/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.wicketstuff.openlayers3.api.layer.Layer;
import org.wicketstuff.openlayers3.api.util.HeaderUtils;

public class ZoomToFeatureExtent
extends Behavior {
    private Number buffer;
    private List<Layer> layers;

    public ZoomToFeatureExtent() {
        this.buffer = null;
        this.layers = null;
    }

    public ZoomToFeatureExtent(Number buffer) {
        this.buffer = buffer;
        this.layers = null;
    }

    public ZoomToFeatureExtent(Layer ... layers) {
        this(null, Arrays.asList(layers));
    }

    public ZoomToFeatureExtent(List<Layer> layers) {
        this(null, layers);
    }

    public ZoomToFeatureExtent(Number buffer, Layer ... layers) {
        this(buffer, Arrays.asList(layers));
    }

    public ZoomToFeatureExtent(Number buffer, List<Layer> layers) {
        this.buffer = buffer;
        this.layers = layers;
    }

    public Number getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Number buffer) {
        this.buffer = buffer;
    }

    public ZoomToFeatureExtent buffer(Number buffer) {
        this.setBuffer(buffer);
        return this;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public ZoomToFeatureExtent layers(List<Layer> layers) {
        this.setLayers(layers);
        return this;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("componentId", component.getMarkupId());
        params.put("buffer", this.buffer != null ? this.buffer.toString() : "NULL");
        if (this.getLayers() != null) {
            StringBuilder layersOut = new StringBuilder();
            for (Layer layer : this.getLayers()) {
                layersOut.append(layer.getJsId());
                if (layersOut.length() <= 0) continue;
                layersOut.append(",");
            }
            params.put("layers", layersOut);
        } else {
            params.put("layers", "NULL");
        }
        HeaderUtils.renderOnDomReady(response, ZoomToFeatureExtent.class, "ZoomToFeatureExtent.js", params);
    }
}

