/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import org.wicketstuff.openlayers3.api.coordinate.CoordinateProjected;

public class ViewEvent
implements Serializable {
    private final JsonObject jsonViewEvent;
    private String projection;
    private CoordinateProjected[] extent;
    private CoordinateProjected center;

    public ViewEvent(JsonObject jsonViewEvent) {
        this.jsonViewEvent = jsonViewEvent;
        this.transformValues();
    }

    public String getProjection() {
        return this.projection;
    }

    public CoordinateProjected[] getExtent() {
        return this.extent;
    }

    public CoordinateProjected getCenter() {
        return this.center;
    }

    public JsonObject getJsonObject() {
        return this.jsonViewEvent;
    }

    private String transformProjection() {
        JsonPrimitive projection = this.jsonViewEvent.getAsJsonPrimitive("transformedProjection");
        return projection.toString();
    }

    private CoordinateProjected[] transFormExtent() {
        ArrayList<Double> values = new ArrayList<Double>();
        JsonArray transformedExtent = this.jsonViewEvent.getAsJsonArray("transformedExtent");
        for (JsonElement element : transformedExtent) {
            values.add(element.getAsDouble());
        }
        CoordinateProjected coordinate1 = new CoordinateProjected((Number)values.get(0), (Number)values.get(1), this.getProjection());
        CoordinateProjected coordinate2 = new CoordinateProjected((Number)values.get(2), (Number)values.get(3), this.getProjection());
        return new CoordinateProjected[]{coordinate1, coordinate2};
    }

    private CoordinateProjected transformCenter() {
        ArrayList<Double> values = new ArrayList<Double>();
        JsonArray transformedExtent = this.jsonViewEvent.getAsJsonArray("center");
        for (JsonElement element : transformedExtent) {
            values.add(element.getAsDouble());
        }
        CoordinateProjected coordinate = new CoordinateProjected((Number)values.get(0), (Number)values.get(1), this.getProjection());
        return coordinate;
    }

    private void transformValues() {
        this.projection = this.transformProjection();
        this.extent = this.transFormExtent();
        this.center = this.transformCenter();
    }
}

