/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers3.behavior.view;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.openlayers3.api.layer.Vector;
import org.wicketstuff.openlayers3.api.util.HeaderUtils;
import org.wicketstuff.openlayers3.behavior.view.ViewEvent;

public abstract class ViewEventFeaturesListener
extends AbstractDefaultAjaxBehavior {
    public static final String DEFAULT_PROJECTION = "EPSG:4326";
    private static Long counter = 0L;
    private static Map<Object, String> objectIds = new HashMap<Object, String>();
    private String projection;
    private Vector vector;

    public ViewEventFeaturesListener(Vector vectorLayer) {
        this(DEFAULT_PROJECTION, vectorLayer);
    }

    public ViewEventFeaturesListener(String projection, Vector vectorLayer) {
        this.vector = vectorLayer;
        this.projection = projection;
    }

    public abstract void handleViewEvent(AjaxRequestTarget var1, ViewEvent var2, JsonArray var3);

    public String getCallbackFunctionName() {
        return "viewEventFeaturesHandler_" + this.getId();
    }

    public String getId() {
        Object objectId = null;
        if (objectIds.get((Object)this) != null) {
            objectId = objectIds.get((Object)this);
        } else {
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
            objectId = ((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + l;
            objectIds.put((Object)this, (String)objectId);
        }
        return objectId;
    }

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String viewJson = params.getParameterValue("view").toString();
        String featuresJson = params.getParameterValue("features").toString();
        ViewEvent viewEvent = null;
        JsonElement viewParsed = new JsonParser().parse(viewJson);
        if (!(viewParsed instanceof JsonNull)) {
            viewEvent = new ViewEvent(viewParsed.getAsJsonObject());
        }
        JsonArray features = null;
        JsonElement featuresParsed = new JsonParser().parse(featuresJson);
        if (!(featuresParsed instanceof JsonNull)) {
            features = featuresParsed.getAsJsonArray();
        }
        this.handleViewEvent(target, viewEvent, features);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("callbackUrl", this.getCallbackUrl());
        params.put("callbackFunctionName", this.getCallbackFunctionName());
        params.put("componentId", component.getMarkupId());
        params.put("layerId", this.vector.getJsId());
        params.put("projection", this.projection != null ? this.projection : "NULL");
        HeaderUtils.renderOnDomReady(response, ViewEventFeaturesListener.class, "ViewEventFeaturesListener.js", params);
    }
}

