/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.excel;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.wicketstuff.poi.excel.CellExporter;
import org.wicketstuff.poi.excel.GeneralPurposeExporter;
import org.wicketstuff.poi.excel.TableParser;
import org.wicketstuff.poi.excel.XlsStream;

public class TableComponentAsXlsHandler
implements IRequestHandler {
    private Component tableComponent;
    private String filename;
    private CellExporter cellExporter = new GeneralPurposeExporter();

    public TableComponentAsXlsHandler(Component tableComponent, String filename) {
        this.tableComponent = tableComponent;
        this.filename = filename;
    }

    public void respond(IRequestCycle requestCycle) {
        try {
            TableParser parser = new TableParser(this.newSheet(), this.cellExporter);
            if (this.tableComponent instanceof IPageable) {
                IPageable pageable = (IPageable)this.tableComponent;
                int i = 0;
                while ((long)i < pageable.getPageCount()) {
                    pageable.setCurrentPage((long)i);
                    parser.parse(this.tableComponent);
                    ++i;
                }
            } else {
                parser.parse(this.tableComponent);
            }
            XlsStream xlsStream = new XlsStream(parser.getSheet().getWorkbook());
            ResourceStreamResource resource = new ResourceStreamResource((IResourceStream)xlsStream);
            resource.setFileName(this.filename);
            resource.setContentDisposition(ContentDisposition.ATTACHMENT);
            IResource.Attributes a = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse());
            resource.respond(a);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating a xls file to table component", e);
        }
    }

    public void detach(IRequestCycle requestCycle) {
        this.tableComponent = null;
    }

    protected Sheet newSheet() {
        return new HSSFWorkbook().createSheet("data");
    }

    public void setCellExporter(CellExporter cellExporter) {
        this.cellExporter = cellExporter;
    }
}

