/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.excel;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.wicketstuff.poi.excel.CellExporter;

public class TableParser {
    private Row row;
    private Cell cell;
    private final Map<Integer, Integer> rowsToSpanByColumn = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> columnSpan = new HashMap<Integer, Integer>();
    private int colsToSpan;
    private final Sheet targetSheet;
    private CellExporter cellExporter;
    private Response originalResponse;

    public TableParser(Sheet sheet, CellExporter cellExporter) {
        this.cellExporter = cellExporter;
        this.targetSheet = sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Component tableComponent) throws IOException, ResourceStreamNotFoundException, ParseException {
        try {
            BufferedWebResponse mockResponse = this.doRequest(tableComponent);
            this.doParse(mockResponse.getText(), tableComponent);
        }
        finally {
            this.afterParse(tableComponent);
        }
    }

    private void doParse(CharSequence gridComponentMarkup, Component tableComponent) throws IOException, ResourceStreamNotFoundException, ParseException {
        XmlTag tag;
        XmlPullParser parser = new XmlPullParser();
        parser.parse(gridComponentMarkup);
        int tableDeep = 0;
        while ((tag = parser.nextTag()) != null) {
            int index;
            if ("table".equals(tag.getName().toLowerCase())) {
                tableDeep = tag.isOpen() ? ++tableDeep : --tableDeep;
            }
            if (tableDeep > 1 || !tag.isOpen()) continue;
            String tagName = tag.getName().toLowerCase();
            if ("tr".equals(tagName)) {
                if (tableDeep == 0) {
                    tableDeep = 1;
                }
                index = this.row == null ? 0 : this.row.getRowNum() + 1;
                this.row = this.targetSheet.createRow(index);
                this.cell = null;
                continue;
            }
            if (!"td".equals(tagName) && !"th".equals(tagName)) continue;
            int n = index = this.cell == null ? 0 : this.cell.getColumnIndex() + 1 + this.colsToSpan;
            while (this.skipColumn(index)) {
                index += this.columnSpan.get(index).intValue();
            }
            this.colsToSpan = 0;
            CharSequence rowspan = tag.getAttribute("rowspan");
            CharSequence colspan = tag.getAttribute("colspan");
            this.cell = this.row.createCell(index);
            if (rowspan != null || colspan != null) {
                int rowsToSpan = rowspan == null ? 0 : Integer.valueOf(rowspan.toString()) - 1;
                int n2 = this.colsToSpan = colspan == null ? 0 : Integer.valueOf(colspan.toString()) - 1;
                if (rowsToSpan > 0) {
                    this.rowsToSpanByColumn.put(index, rowsToSpan);
                    this.columnSpan.put(index, this.colsToSpan + 1);
                }
                int lastRowNum = this.row.getRowNum() + rowsToSpan;
                int lastColIndex = index + this.colsToSpan;
                this.targetSheet.addMergedRegion(new CellRangeAddress(this.row.getRowNum(), lastRowNum, index, lastColIndex));
            }
            this.cellExporter.exportCell(tag, parser, this.cell, tableComponent);
        }
    }

    private boolean skipColumn(int column) {
        Integer rowspan = this.rowsToSpanByColumn.remove(column);
        if (rowspan != null && rowspan > 0) {
            this.rowsToSpanByColumn.put(column, rowspan - 1);
            return true;
        }
        return false;
    }

    private BufferedWebResponse doRequest(Component tableComponent) {
        this.originalResponse = RequestCycle.get().getResponse();
        BufferedWebResponse mockResponse = new BufferedWebResponse(null);
        RequestCycle.get().setResponse((Response)mockResponse);
        Application.get().getComponentPreOnBeforeRenderListeners().add((Object)PathSetupListener.INSTANCE);
        Page page = tableComponent.getPage();
        page.startComponentRender(tableComponent);
        tableComponent.prepareForRender();
        tableComponent.render();
        return mockResponse;
    }

    private void afterParse(Component tableComponent) {
        tableComponent.getPage().endComponentRender(tableComponent);
        Application.get().getComponentPreOnBeforeRenderListeners().remove((Object)PathSetupListener.INSTANCE);
        RequestCycle.get().setResponse(this.originalResponse);
        this.originalResponse = null;
    }

    public Sheet getSheet() {
        return this.targetSheet;
    }

    public static class OutputPathBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;
        public static final String PATH_ATTRIBUTE = "component_path";
        public static final OutputPathBehavior INSTANCE = new OutputPathBehavior();
        private boolean removing;

        public void onComponentTag(Component component, ComponentTag tag) {
            tag.put(PATH_ATTRIBUTE, (CharSequence)component.getPageRelativePath());
        }

        public void detach(Component component) {
            if (this.removing) {
                return;
            }
            this.removing = true;
            component.remove(new Behavior[]{this});
            this.removing = false;
        }
    }

    private static class PathSetupListener
    implements IComponentOnBeforeRenderListener {
        public static final PathSetupListener INSTANCE = new PathSetupListener();

        private PathSetupListener() {
        }

        public void onBeforeRender(Component component) {
            component.add(new Behavior[]{OutputPathBehavior.INSTANCE});
        }
    }
}

