/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.poi.excel;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.wicketstuff.poi.excel.CellExporter;
import org.wicketstuff.poi.excel.GeneralPurposeExporter;
import org.wicketstuff.poi.excel.TableParser;
import org.wicketstuff.poi.excel.XlsStream;

public class TablesComponentAsXlsHandler
implements IRequestHandler {
    private Component[] tableComponents;
    private String filename;
    private CellExporter cellExporter = new GeneralPurposeExporter();
    private Workbook workbook;

    public TablesComponentAsXlsHandler(String filename, Component ... tableComponents) {
        if (tableComponents == null) {
            throw new IllegalArgumentException("At least one table compont should be passed as argument!");
        }
        this.tableComponents = tableComponents;
        this.filename = filename;
    }

    public void respond(IRequestCycle requestCycle) {
        try {
            this.workbook = new HSSFWorkbook();
            int index = 0;
            for (Component tableComponent : this.tableComponents) {
                TableParser parser = new TableParser(this.newSheet(this.workbook, tableComponent, index++), this.cellExporter);
                if (tableComponent instanceof IPageable) {
                    IPageable pageable = (IPageable)tableComponent;
                    int i = 0;
                    while ((long)i < pageable.getPageCount()) {
                        pageable.setCurrentPage((long)i);
                        parser.parse(tableComponent);
                        ++i;
                    }
                    continue;
                }
                parser.parse(tableComponent);
            }
            XlsStream xlsStream = new XlsStream(this.workbook);
            ResourceStreamResource resource = new ResourceStreamResource((IResourceStream)xlsStream);
            resource.setFileName(this.filename);
            resource.setContentDisposition(ContentDisposition.ATTACHMENT);
            IResource.Attributes a = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse());
            resource.respond(a);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating a xls file to table component", e);
        }
    }

    public void detach(IRequestCycle requestCycle) {
        this.tableComponents = null;
    }

    protected Sheet newSheet(Workbook workbook, Component component, int index) {
        return workbook.createSheet("Worksheet " + component.getId());
    }

    public void setCellExporter(CellExporter cellExporter) {
        this.cellExporter = cellExporter;
    }
}

