/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public class ServerHostNameAndTimeFilter
implements IResponseFilter {
    private String host;

    public ServerHostNameAndTimeFilter() {
        String hostId = null;
        try {
            hostId = System.getProperty("examples.hostname");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (Strings.isEmpty((CharSequence)hostId)) {
            hostId = String.valueOf(System.currentTimeMillis());
        }
        this.setHostName(hostId);
    }

    public ServerHostNameAndTimeFilter(String hostId) {
        if (hostId == null) {
            throw new IllegalArgumentException("hostId may not be null");
        }
        this.setHostName(hostId);
    }

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int index = responseBuffer.indexOf("<head>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (index != -1) {
            AppendingStringBuffer script = new AppendingStringBuffer(75);
            script.append("\n");
            script.append("<script type=\"text/javascript\">\n/*<![CDATA[*/\n");
            script.append("\n\twindow.defaultStatus='");
            script.append("Host: ");
            script.append(this.host);
            script.append(", handled in: ");
            script.append((Object)Duration.milliseconds((long)timeTaken));
            script.append("';\n");
            script.append("\n/*]]>*/\n</script>\n");
            script.append("\n");
            responseBuffer.insert(index + 6, (Object)script);
        }
        return responseBuffer;
    }

    private void setHostName(String hostId) {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            String hostName = localMachine.getHostName();
            String address = localMachine.getHostAddress();
            this.host = (!Strings.isEmpty((CharSequence)hostName) ? hostName + "/" + address : address) + "/" + hostId;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (Strings.isEmpty((CharSequence)this.host)) {
            this.host = "<unknown>";
        }
    }
}

