/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.authorization;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.examples.authorization.Index;
import org.apache.wicket.examples.authorization.RolesSession;
import org.apache.wicket.examples.authorization.User;
import org.apache.wicket.examples.authorization.UserRolesAuthorizer;
import org.apache.wicket.examples.authorization.pages.AdminBookmarkablePage;
import org.apache.wicket.examples.authorization.pages.AdminInternalPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;

public class RolesApplication
extends WebApplication {
    public static List<User> USERS = Arrays.asList(new User("jon", "ADMIN"), new User("kay", "USER"), new User("pam", ""));

    public Class<? extends Page> getHomePage() {
        return Index.class;
    }

    public Session newSession(Request request, Response response) {
        return new RolesSession(request);
    }

    protected void init() {
        super.init();
        this.getDebugSettings().setDevelopmentUtilitiesEnabled(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)new UserRolesAuthorizer()));
        MetaDataRoleAuthorizationStrategy.authorize(AdminBookmarkablePage.class, (String)"ADMIN");
        MetaDataRoleAuthorizationStrategy.authorize(AdminInternalPage.class, (String)"ADMIN");
    }
}

