/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.bean.validation.constraint;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.wicket.examples.bean.validation.constraint.ValidPassword;

public class ValidPasswordValidator
implements ConstraintValidator<ValidPassword, String> {
    private final Pattern content = Pattern.compile("[0-9a-zA-Z]*");
    private final Pattern digits = Pattern.compile("(.*\\d.*){2}");

    public void initialize(ValidPassword constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        boolean validationResult = true;
        if (!this.content.matcher(value).matches()) {
            validationResult = false;
        } else if (!this.digits.matcher(value).matches()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("{password.needDigits}").addConstraintViolation();
            validationResult = false;
        }
        return validationResult;
    }
}

