/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.compref;

import org.apache.wicket.Component;
import org.apache.wicket.examples.WicketExamplePage;
import org.apache.wicket.examples.compref.ExplainPanel;
import org.apache.wicket.examples.compref.TextFieldPage;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public class TextFieldPage
extends WicketExamplePage {
    public TextFieldPage() {
        Input input = new Input(null);
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)input));
        FeedbackPanel feedbackPanel = new FeedbackPanel("feedback");
        this.add(new Component[]{feedbackPanel});
        1 form = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("text")});
        form.add(new Component[]{new TextField("integer", Integer.class)});
    }

    protected void explain() {
        String html = "<input type=\"text\" wicket:id=\"text\" />\n<input type=\"text\" wicket:id=\"integer\" />";
        String code = "&nbsp;&nbsp;&nbsp;&nbsp;// add a simple text field that uses Input's 'text' property. Nothing can go wrong here\n&nbsp;&nbsp;&nbsp;&nbsp;form.add(new TextField(\"text\"));\n\n&nbsp;&nbsp;&nbsp;&nbsp;// here we add a text field that uses Input's 'integer' property. Something could go\n&nbsp;&nbsp;&nbsp;&nbsp;// wrong here, as the user's (textual) input might be an invalid value for an\n&nbsp;&nbsp;&nbsp;&nbsp;// Integer object. If we provide the class constructor argument like we do here, we\n&nbsp;&nbsp;&nbsp;&nbsp;// get two things:\n&nbsp;&nbsp;&nbsp;&nbsp;// 1. A type validator is added, so that before any actual updating is tried, first the\n&nbsp;&nbsp;&nbsp;&nbsp;// &nbsp;&nbsp;&nbsp;&nbsp;user input is checked for validity. When the user input is wrong for an integer,\n&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;&nbsp;&nbsp;&nbsp;the model updating is cancelled, and an error message is displayed to the user\n&nbsp;&nbsp;&nbsp;&nbsp;// 2.When updating the model, the given type is explicitly used instead of trying\n&nbsp;&nbsp;&nbsp;&nbsp;//&nbsp;&nbsp;&nbsp;&nbsp;to figure out what type should be converted to.\n&nbsp;&nbsp;&nbsp;&nbsp;// Note that the default validation message mechanism uses resource bundles for the actual\n&nbsp;&nbsp;&nbsp;&nbsp;// message lookup. The message for this component can be found in TextFieldPage.properties\n&nbsp;&nbsp;&nbsp;&nbsp;// with key 'form.integer.IConverter'. Read more about how this works in the javadocs\n&nbsp;&nbsp;&nbsp;&nbsp;// of AbstractValidator\n&nbsp;&nbsp;&nbsp;&nbsp;form.add(new TextField(\"integer\", Integer.class));";
        this.add(new Component[]{new ExplainPanel(html, code)});
    }
}

