/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.forminput;

import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.SharedResources;
import org.apache.wicket.examples.WicketExampleApplication;
import org.apache.wicket.examples.forminput.FormInput;
import org.apache.wicket.markup.html.image.resource.DefaultButtonImageResource;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.IResource;

public class FormInputApplication
extends WicketExampleApplication {
    public static final List<Locale> LOCALES = Arrays.asList(Locale.ENGLISH, new Locale("nl", "NL"), Locale.GERMAN, Locale.SIMPLIFIED_CHINESE, Locale.JAPANESE, new Locale("pt", "BR"), new Locale("fa", "IR"), new Locale("da", "DK"), new Locale("th", "TH"), new Locale("ru"), new Locale("ko", "KR"));

    public Class<? extends Page> getHomePage() {
        return FormInput.class;
    }

    public Session newSession(Request request, Response response) {
        WebSession session = new WebSession(request);
        Locale locale = session.getLocale();
        if (!LOCALES.contains(locale)) {
            session.setLocale(Locale.ENGLISH);
        }
        return session;
    }

    protected void init() {
        super.init();
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        Font font = new Font("SimSun", 1, 16);
        DefaultButtonImageResource imgSave = new DefaultButtonImageResource("\u4fdd\u5b58");
        imgSave.setFont(font);
        DefaultButtonImageResource imgReset = new DefaultButtonImageResource("\u91cd\u7f6e");
        imgReset.setFont(font);
        SharedResources sharedResources = this.getSharedResources();
        sharedResources.add("save", Locale.SIMPLIFIED_CHINESE, (IResource)imgSave);
        sharedResources.add("reset", Locale.SIMPLIFIED_CHINESE, (IResource)imgReset);
        Font fontJa = new Font("Serif", 1, 16);
        DefaultButtonImageResource imgSaveJa = new DefaultButtonImageResource("\u4fdd\u5b58");
        imgSaveJa.setFont(fontJa);
        DefaultButtonImageResource imgResetJa = new DefaultButtonImageResource("\u30ea\u30bb\u30c3\u30c8");
        imgResetJa.setFont(fontJa);
        sharedResources.add("save", Locale.JAPANESE, (IResource)imgSaveJa);
        sharedResources.add("reset", Locale.JAPANESE, (IResource)imgResetJa);
        Font fontFa = new Font("Serif", 1, 16);
        Locale farsi = new Locale("fa", "IR");
        DefaultButtonImageResource imgSaveFa = new DefaultButtonImageResource("\u0630\u062e\u064a\u0631\u0647");
        imgSaveFa.setFont(fontFa);
        DefaultButtonImageResource imgResetFa = new DefaultButtonImageResource("\u0628\u0627\u0632\u0646\u0634\u0627\u0646\u064a");
        imgResetFa.setFont(fontFa);
        this.getSharedResources().add("save", farsi, (IResource)imgSaveFa);
        this.getSharedResources().add("reset", farsi, (IResource)imgResetFa);
    }
}

