/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.hangman;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.examples.hangman.Letter;
import org.apache.wicket.examples.hangman.Word;
import org.apache.wicket.examples.hangman.WordGenerator;
import org.apache.wicket.util.io.IClusterable;

public class Game
implements IClusterable {
    private int guessesAllowed;
    private int guessesRemaining;
    private final List<Letter> letters = new ArrayList();
    private Word word;
    private WordGenerator wordGenerator;

    public int getGuessesRemaining() {
        return this.guessesRemaining;
    }

    public List<Letter> getLetters() {
        return this.letters;
    }

    public Word getWord() {
        return this.word;
    }

    public boolean guess(Letter letter) {
        if (!letter.isGuessed()) {
            boolean correct = this.word.guess(letter);
            if (!correct) {
                --this.guessesRemaining;
            }
            return correct;
        }
        return false;
    }

    public boolean isLost() {
        return this.guessesRemaining == 0;
    }

    public boolean isWon() {
        return this.word.isGuessed();
    }

    public void newGame() {
        this.newGame(this.guessesAllowed, this.wordGenerator);
    }

    public void newGame(int guessesAllowed, WordGenerator wordGenerator) {
        this.guessesAllowed = guessesAllowed;
        this.guessesRemaining = guessesAllowed;
        this.word = wordGenerator.next();
        this.wordGenerator = wordGenerator;
        this.letters.clear();
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            this.letters.add(new Letter(c));
        }
    }
}

