/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.hangman;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.examples.hangman.Letter;
import org.apache.wicket.util.io.IClusterable;

public class Word
implements IClusterable {
    final List<Letter> letters = new ArrayList();

    public Word(String word) {
        for (int i = 0; i < word.length(); ++i) {
            this.letters.add(new Letter(word.charAt(i)));
        }
    }

    public String asString() {
        return this.asString(false);
    }

    public String asString(boolean hideUnguessed) {
        StringBuilder buffer = new StringBuilder();
        for (Letter letter : this.letters) {
            if (hideUnguessed) {
                buffer.append(letter.isGuessed() ? letter.asString() : "_");
                continue;
            }
            buffer.append(letter.asString());
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Word) {
            Word that = (Word)object;
            return this.asString().equalsIgnoreCase(that.asString());
        }
        return false;
    }

    public boolean guess(Letter letter) {
        boolean correct = false;
        for (Letter current : this.letters) {
            if (!current.equals((Object)letter)) continue;
            current.guess();
            correct = true;
        }
        letter.guess();
        return correct;
    }

    public int hashCode() {
        return this.asString().hashCode();
    }

    public boolean isGuessed() {
        for (Letter letter : this.letters) {
            if (letter.isGuessed()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[Word letters = " + this.letters + "]";
    }
}

