/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.hangman;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.examples.hangman.Word;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class WordGenerator
implements IClusterable {
    private final List<String> words;
    private int index;

    public WordGenerator() {
        try {
            IResourceStream resource = new ResourceStreamLocator().locate(WordGenerator.class, "org/apache/wicket/examples/hangman/WordList", null, null, Locale.getDefault(), ".txt", false);
            String wordlist = Streams.readString((InputStream)resource.getInputStream());
            this.words = Arrays.asList(wordlist.split("\\s+"));
            this.shuffle();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read word list");
        }
        catch (ResourceStreamNotFoundException e) {
            throw new RuntimeException("Couldn't read word list");
        }
    }

    public WordGenerator(String[] words) {
        this.words = Arrays.asList(words);
        this.shuffle();
    }

    public Word next() {
        if (this.index == this.words.size()) {
            this.shuffle();
        }
        return new Word((String)this.words.get(this.index++));
    }

    public int size() {
        return this.words.size();
    }

    private void shuffle() {
        Collections.shuffle(this.words);
        this.index = 0;
    }
}

