/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.examples.library.Book;
import org.apache.wicket.util.io.IClusterable;

public final class Book
implements IClusterable {
    public static final boolean FICTION = true;
    public static final boolean NON_FICTION = false;
    public static final WritingStyle FUNNY = new WritingStyle("funny");
    public static final WritingStyle BORING = new WritingStyle("boring");
    public static final WritingStyle SAD = new WritingStyle("sad");
    public static final WritingStyle BAD = new WritingStyle("bad");
    private static long nextId = 0L;
    private static final Map<Long, Book> idToBook = new HashMap();
    private long id;
    private String title;
    private String author;
    private Book companionBook;
    private Book relatedBook;
    private boolean isFiction;
    private List<WritingStyle> writingStyles = new ArrayList();

    public Book(String title, String author, boolean isFiction) {
        this.id = nextId++;
        this.title = title;
        this.author = author;
        this.isFiction = isFiction;
        this.add(this);
    }

    private void add(Book book) {
        boolean hit = false;
        for (Book value : idToBook.values()) {
            if (!value.toString().equals(book.toString())) continue;
            book.id = value.id;
            hit = true;
            break;
        }
        if (!hit) {
            idToBook.put(book.id, book);
        }
    }

    public static Book get(long id) {
        return (Book)idToBook.get(id);
    }

    public static Collection<Book> getBooks() {
        return idToBook.values();
    }

    public final long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setAuthor(String string) {
        this.author = string;
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public final Book getCompanionBook() {
        return this.companionBook;
    }

    public final void setCompanionBook(Book book) {
        this.companionBook = book;
    }

    public final void setFiction(boolean isFiction) {
        this.isFiction = isFiction;
    }

    public final boolean getFiction() {
        return this.isFiction;
    }

    public final List<WritingStyle> getWritingStyles() {
        return this.writingStyles;
    }

    public final void setWritingStyles(List<WritingStyle> writingStyles) {
        this.writingStyles = writingStyles;
    }

    public final Book getRelatedBook() {
        return this.relatedBook;
    }

    public final void setRelatedBook(Book relatedBook) {
        this.relatedBook = relatedBook;
    }

    public final String toString() {
        return this.title + " (" + this.author + ")";
    }

    static {
        new Book("Cat in Hat", "Dr. Seuss", true);
        new Book("That is Highly Illogical", "Dr. Spock", false);
        new Book("Where's my Tardis, dude?", "Dr. Who", true);
    }
}

