/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.library;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.examples.library.AuthenticatedWebPage;
import org.apache.wicket.examples.library.Book;
import org.apache.wicket.examples.library.BookDetails;
import org.apache.wicket.examples.library.EditBook;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValueConversionException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BookDetails
extends AuthenticatedWebPage {
    public BookDetails(PageParameters parameters) throws StringValueConversionException {
        this(Book.get((long)parameters.get("id").toLong()));
    }

    public BookDetails(Book book) {
        String writingStyles;
        boolean hasStyles;
        this.add(new Component[]{new Label("title", (Serializable)((Object)book.getTitle()))});
        this.add(new Component[]{new Label("author", (Serializable)((Object)book.getAuthor()))});
        this.add(new Component[]{new Label("fiction", (Serializable)((Object)Boolean.toString(book.getFiction())))});
        this.add(new Component[]{BookDetails.link((String)"companion", (Book)book.getCompanionBook(), (String)this.getLocalizer().getString("noBookTitle", (Component)this))});
        this.add(new Component[]{BookDetails.link((String)"related", (Book)book.getRelatedBook(), (String)this.getLocalizer().getString("noBookTitle", (Component)this))});
        boolean bl = hasStyles = book.getWritingStyles() != null && book.getWritingStyles().size() > 0;
        if (hasStyles) {
            StringList styles = new StringList();
            for (Book.WritingStyle style : book.getWritingStyles()) {
                styles.add(this.getLocalizer().getString(style.toString(), (Component)this));
            }
            writingStyles = styles.toString();
        } else {
            writingStyles = this.getLocalizer().getString("noWritingStyles", (Component)this);
        }
        Label writingStylesLabel = new Label("writingStyles", (Serializable)((Object)writingStyles));
        1 italic = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{writingStylesLabel.add(new Behavior[]{italic})});
        this.add(new Component[]{EditBook.link((String)"edit", (long)book.getId())});
    }

    public static BookmarkablePageLink<Void> link(String name, Book book, String noBookTitle) {
        BookmarkablePageLink link = new BookmarkablePageLink(name, BookDetails.class);
        if (book != null) {
            link.getPageParameters().add("id", (Object)book.getId());
            link.add(new Component[]{new Label("title", (IModel)new Model((Serializable)book))});
        } else {
            link.add(new Component[]{new Label("title", (Serializable)((Object)noBookTitle))});
            link.setEnabled(false);
        }
        return link;
    }
}

