/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.repeater;

import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.wicket.examples.repeater.Contact;

public class ContactGenerator {
    private static ContactGenerator instance = new ContactGenerator();
    private static long nextId = 1L;
    private final String[] firstNames = new String[]{"Jacob", "Emily", "Michael", "Sarah", "Matthew", "Brianna", "Nicholas", "Samantha", "Christopher", "Hailey", "Abner", "Abby", "Joshua", "Douglas", "Jack", "Keith", "Gerald", "Samuel", "Willie", "Larry", "Jose", "Timothy", "Sandra", "Kathleen", "Pamela", "Virginia", "Debra", "Maria", "Linda"};
    private final String[] lastNames = new String[]{"Smiith", "Johnson", "Williams", "Jones", "Brown", "Donahue", "Bailey", "Rose", "Allen", "Black", "Davis", "Clark", "Hall", "Lee", "Baker", "Gonzalez", "Nelson", "Moore", "Wilson", "Graham", "Fisher", "Cruz", "Ortiz", "Gomez", "Murray"};

    public static ContactGenerator getInstance() {
        return instance;
    }

    private ContactGenerator() {
    }

    public synchronized long generateId() {
        return nextId++;
    }

    public Contact generate() {
        Contact contact = new Contact(this.randomString(this.firstNames), this.randomString(this.lastNames));
        contact.setId(this.generateId());
        contact.setHomePhone(this.generatePhoneNumber());
        contact.setCellPhone(this.generatePhoneNumber());
        contact.setBornDate(this.generateDate());
        return contact;
    }

    public void generate(Collection<Contact> collection, int count) {
        for (int i = 0; i < count; ++i) {
            collection.add(this.generate());
        }
    }

    private String generatePhoneNumber() {
        return "" + this.rint(2, 9) + this.rint(0, 9) + this.rint(0, 9) + "-555-" + this.rint(1, 9) + this.rint(0, 9) + this.rint(0, 9) + this.rint(0, 9);
    }

    private int rint(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private String randomString(String[] choices) {
        return choices[this.rint(0, choices.length)];
    }

    private Date generateDate() {
        GregorianCalendar gc = new GregorianCalendar();
        int year = this.rint(1950, 1985);
        gc.set(1, year);
        int dayOfYear = this.rint(1, gc.getActualMaximum(6));
        gc.set(6, dayOfYear);
        return gc.getTime();
    }
}

