/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.repeater;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.examples.repeater.Contact;
import org.apache.wicket.examples.repeater.ContactGenerator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ContactsDatabase {
    private final Map<Long, Contact> map = Collections.synchronizedMap(new HashMap());
    private final List<Contact> fnameIdx = Collections.synchronizedList(new ArrayList());
    private final List<Contact> lnameIdx = Collections.synchronizedList(new ArrayList());
    private final List<Contact> fnameDescIdx = Collections.synchronizedList(new ArrayList());
    private final List<Contact> lnameDescIdx = Collections.synchronizedList(new ArrayList());

    public ContactsDatabase(int count) {
        for (int i = 0; i < count; ++i) {
            this.add(ContactGenerator.getInstance().generate());
        }
        this.updateIndecies();
    }

    public Contact get(long id) {
        Contact c = (Contact)this.map.get(id);
        if (c == null) {
            throw new RuntimeException("contact with id [" + id + "] not found in the database");
        }
        return c;
    }

    protected void add(Contact contact) {
        this.map.put(contact.getId(), contact);
        this.fnameIdx.add(contact);
        this.lnameIdx.add(contact);
        this.fnameDescIdx.add(contact);
        this.lnameDescIdx.add(contact);
    }

    public List<Contact> find(long first, long count, SortParam sort) {
        return this.getIndex(sort).subList((int)first, (int)(first + count));
    }

    public List<Contact> getIndex(SortParam sort) {
        if (sort == null) {
            return this.fnameIdx;
        }
        if (sort.getProperty().equals("firstName")) {
            return sort.isAscending() ? this.fnameIdx : this.fnameDescIdx;
        }
        if (sort.getProperty().equals("lastName")) {
            return sort.isAscending() ? this.lnameIdx : this.lnameDescIdx;
        }
        throw new RuntimeException("unknown sort option [" + sort + "]. valid fields: [firstName], [lastName]");
    }

    public int getCount() {
        return this.fnameIdx.size();
    }

    public void save(Contact contact) {
        if (contact.getId() != 0L) {
            throw new IllegalArgumentException("contact [" + contact.getFirstName() + "] is already persistent");
        }
        contact.setId(ContactGenerator.getInstance().generateId());
        this.add(contact);
        this.updateIndecies();
    }

    public void delete(Contact contact) {
        this.map.remove(contact.getId());
        this.fnameIdx.remove(contact);
        this.lnameIdx.remove(contact);
        this.fnameDescIdx.remove(contact);
        this.lnameDescIdx.remove(contact);
        contact.setId(0L);
    }

    private void updateIndecies() {
        Collections.sort(this.fnameIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.lnameIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.fnameDescIdx, new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(this.lnameDescIdx, new /* Unavailable Anonymous Inner Class!! */);
    }
}

