/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.repeater;

import org.apache.wicket.examples.repeater.Contact;
import org.apache.wicket.examples.repeater.ContactsDatabase;
import org.apache.wicket.examples.repeater.DatabaseLocator;
import org.apache.wicket.model.LoadableDetachableModel;

public class DetachableContactModel
extends LoadableDetachableModel<Contact> {
    private final long id;

    protected ContactsDatabase getContactsDB() {
        return DatabaseLocator.getDatabase();
    }

    public DetachableContactModel(Contact c) {
        this(c.getId());
    }

    public DetachableContactModel(long id) {
        if (id == 0L) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DetachableContactModel) {
            DetachableContactModel other = (DetachableContactModel)obj;
            return other.id == this.id;
        }
        return false;
    }

    protected Contact load() {
        return this.getContactsDB().get(this.id);
    }
}

