/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.repeater;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.examples.repeater.Contact;
import org.apache.wicket.examples.repeater.ContactFilter;
import org.apache.wicket.examples.repeater.ContactsDatabase;
import org.apache.wicket.examples.repeater.DatabaseLocator;
import org.apache.wicket.examples.repeater.DetachableContactModel;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;

public class SortableContactDataProvider
extends SortableDataProvider<Contact, String>
implements IFilterStateLocator<ContactFilter> {
    private ContactFilter contactFilter = new ContactFilter();

    public SortableContactDataProvider() {
        this.setSort((Object)"firstName", SortOrder.ASCENDING);
    }

    protected ContactsDatabase getContactsDB() {
        return DatabaseLocator.getDatabase();
    }

    public Iterator<Contact> iterator(long first, long count) {
        List contactsFound = this.getContactsDB().getIndex(this.getSort());
        return this.filterContacts(contactsFound).subList((int)first, (int)(first + count)).iterator();
    }

    private List<Contact> filterContacts(List<Contact> contactsFound) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        Date dateFrom = this.contactFilter.getDateFrom();
        Date dateTo = this.contactFilter.getDateTo();
        for (Contact contact : contactsFound) {
            Date bornDate = contact.getBornDate();
            if (dateFrom != null && bornDate.before(dateFrom) || dateTo != null && bornDate.after(dateTo)) continue;
            result.add(contact);
        }
        return result;
    }

    public long size() {
        return this.filterContacts(this.getContactsDB().getIndex(this.getSort())).size();
    }

    public IModel<Contact> model(Contact object) {
        return new DetachableContactModel(object);
    }

    public ContactFilter getFilterState() {
        return this.contactFilter;
    }

    public void setFilterState(ContactFilter state) {
        this.contactFilter = state;
    }
}

