/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.requestmapper;

import java.util.List;
import java.util.Locale;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.mapper.HomePageMapper;
import org.apache.wicket.examples.requestmapper.LocaleHelper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;

public class CustomHomeMapper
extends HomePageMapper {
    public CustomHomeMapper(Class<? extends IRequestablePage> pageClass) {
        super(pageClass);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url homeUrl = super.mapHandler(requestHandler);
        if (homeUrl != null) {
            String locale = Session.get().getLocale().toString();
            homeUrl.getSegments().add(0, locale);
        }
        return homeUrl;
    }

    public IRequestHandler mapRequest(Request request) {
        String localeAsString;
        Locale locale;
        IRequestHandler requestHandler = null;
        Url url = request.getUrl();
        List segments = url.getSegments();
        if (segments.size() == 1 && (locale = LocaleHelper.parseLocale((String)(localeAsString = (String)segments.get(0)))) != null) {
            Session.get().setLocale(locale);
            segments.remove(0);
            Request requestWithoutLocale = request.cloneWithUrl(url);
            requestHandler = super.mapRequest(requestWithoutLocale);
        }
        return requestHandler;
    }

    public int getCompatibilityScore(Request request) {
        return request.getUrl().getSegments().size() == 1 ? 1 : 0;
    }
}

