/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.requestmapper;

import java.util.List;
import java.util.Locale;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.mapper.AbstractComponentMapper;
import org.apache.wicket.examples.requestmapper.LocaleHelper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.string.Strings;

public class LocaleFirstMapper
extends AbstractComponentMapper {
    private final IRequestMapper chain;

    public LocaleFirstMapper(IRequestMapper chain) {
        this.chain = chain;
    }

    public int getCompatibilityScore(Request request) {
        if (this.getLocaleFromUrl(request) != null) {
            request = this.stripLocaleSegment(request);
        }
        return this.chain.getCompatibilityScore(request);
    }

    private Request stripLocaleSegment(Request request) {
        Url url = request.getUrl();
        url.getSegments().remove(0);
        return request.cloneWithUrl(url);
    }

    private Locale getLocaleFromUrl(Request request) {
        String localeAsString;
        List segments = request.getUrl().getSegments();
        if (segments != null && segments.size() > 1 && !Strings.isEmpty((CharSequence)(localeAsString = (String)segments.get(0)))) {
            return LocaleHelper.parseLocale((String)localeAsString);
        }
        return null;
    }

    public IRequestHandler mapRequest(Request request) {
        Locale locale = this.getLocaleFromUrl(request);
        if (locale != null) {
            Session.get().setLocale(locale);
            request = this.stripLocaleSegment(request);
        }
        return this.chain.mapRequest(request);
    }

    public Url mapHandler(IRequestHandler handler) {
        Url url = this.chain.mapHandler(handler);
        if (url != null) {
            Locale locale = Session.get().getLocale();
            if (locale == null) {
                locale = Locale.US;
            }
            url.getSegments().add(0, locale.toString());
        }
        return url;
    }
}

