/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.stockquote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;

public class StockQuote {
    private static final String serviceUrl = "http://www.webservicex.net/stockquote.asmx";
    private String symbol;

    public StockQuote() {
    }

    public StockQuote(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getQuote() {
        String response = this.getSOAPQuote(this.symbol);
        int start = response.indexOf("&lt;Last&gt;") + "&lt;Last&gt;".length();
        int end = response.indexOf("&lt;/Last&gt;");
        if (start < "&lt;Last&gt;".length()) {
            return "(unknown)";
        }
        String result = response.substring(start, end);
        return result.equals("0.00") ? "(unknown)" : result;
    }

    private String getSOAPQuote(String symbol) {
        String response = "";
        try {
            URL url = new URL(serviceUrl);
            String message = this.createMessage(symbol);
            HttpURLConnection httpConn = this.setUpHttpConnection(url, message.length());
            this.writeRequest(message, httpConn);
            response = this.readResult(httpConn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private void writeRequest(String message, HttpURLConnection httpConn) throws IOException {
        OutputStream out = httpConn.getOutputStream();
        out.write(message.getBytes());
        out.close();
    }

    private HttpURLConnection setUpHttpConnection(URL url, int length) throws IOException, ProtocolException {
        URLConnection connection = url.openConnection();
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        httpConn.setRequestProperty("Content-Length", String.valueOf(length));
        httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        httpConn.setRequestProperty("SOAPAction", "\"http://www.webserviceX.NET/GetQuote\"");
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        return httpConn;
    }

    private String readResult(HttpURLConnection connection) throws IOException {
        String inputLine;
        InputStream inputStream = connection.getInputStream();
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            sb.append(inputLine);
        }
        in.close();
        return sb.toString();
    }

    private String createMessage(String symbol) {
        StringBuilder message = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        message.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        message.append("  <soap:Body>");
        message.append("    <GetQuote xmlns=\"http://www.webserviceX.NET/\">");
        message.append("      <symbol>").append(symbol).append("</symbol>");
        message.append("    </GetQuote>");
        message.append("  </soap:Body>");
        message.append("</soap:Envelope>");
        return message.toString();
    }
}

