/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Foo {
    private static final long serialVersionUID = 1L;
    private String id;
    private String bar;
    private String baz;
    private boolean quux;
    private boolean loaded;
    private Foo parent;
    private List<Foo> foos = new ArrayList();

    public Foo(String id) {
        this.id = id;
        this.bar = id.toLowerCase() + "Bar";
        this.baz = id.toLowerCase() + "Baz";
    }

    public Foo(Foo parent, String name) {
        this(name);
        this.parent = parent;
        this.parent.foos.add(this);
    }

    public Foo getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public String getBar() {
        return this.bar;
    }

    public String getBaz() {
        return this.baz;
    }

    public void setBar(String bar) {
        this.bar = bar;
    }

    public void setBaz(String baz) {
        this.baz = baz;
    }

    public void setQuux(boolean quux) {
        this.quux = quux;
        if (quux) {
            for (Foo foo : this.foos) {
                foo.setQuux(true);
            }
        } else if (this.parent != null) {
            this.parent.setQuux(false);
        }
    }

    public boolean getQuux() {
        return this.quux;
    }

    public List<Foo> getFoos() {
        return Collections.unmodifiableList(this.foos);
    }

    public String toString() {
        return this.id;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

