/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.cometd;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.cometd.server.CometdServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.cometd.CometdPushEventContext;
import org.wicketstuff.push.cometd.CometdPushNode;
import org.wicketstuff.push.cometd.CometdPushService;

public class CometdPushBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CometdPushBehavior.class);
    private static final String DEFAULT_COMETD_PATH = CometdPushBehavior.guessCometdServletPath();
    private static final ResourceReference COMETD = new PackageResourceReference(CometdPushBehavior.class, "org/cometd.js");
    private static final ResourceReference COMETD_ACK = new PackageResourceReference(CometdPushBehavior.class, "org/cometd/AckExtension.js");
    private static final ResourceReference COMETD_RELOAD = new PackageResourceReference(CometdPushBehavior.class, "org/cometd/ReloadExtension.js");
    private static final ResourceReference COMETD_TIMESTAMP = new PackageResourceReference(CometdPushBehavior.class, "org/cometd/TimeStampExtension.js");
    private static final ResourceReference COMETD_TIMESYNC = new PackageResourceReference(CometdPushBehavior.class, "org/cometd/TimeSyncExtension.js");
    private static final PackageTextTemplate TEMPLATE_INIT = new PackageTextTemplate(CometdPushBehavior.class, "CometdPushInit.js");
    private static final PackageTextTemplate TEMPLATE_EVENT_HANDLER = new PackageTextTemplate(CometdPushBehavior.class, "CometdPushEventHandlerTemplate.js");
    private static final PackageTextTemplate TEMPLATE_SUBSCRIBE = new PackageTextTemplate(CometdPushBehavior.class, "CometdPushSubscribeTemplate.js");
    private final String _cometdChannelId;
    private final String _cometdChannelIdWithoutSlash;
    private final Map<CometdPushNode, IPushEventHandler> _handlers = new HashMap<CometdPushNode, IPushEventHandler>(2);

    private static String guessCometdServletPath() {
        ServletContext servletContext = ((WebApplication)Application.get()).getServletContext();
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        try {
            XmlTag elem;
            XmlPullParser parser = new XmlPullParser();
            parser.parse(is);
            String urlPattern = null;
            while (!((elem = parser.nextTag()) == null || elem.getName().equals("servlet") && elem.isOpen())) {
            }
            if (elem != null) {
                String servletName = null;
                String servletClassName = null;
                do {
                    if ((elem = parser.nextTag()).isOpen()) {
                        parser.setPositionMarker();
                        continue;
                    }
                    if (elem.isClose() && elem.getName().equals("servlet-name")) {
                        servletName = parser.getInputFromPositionMarker(elem.getPos()).toString();
                        continue;
                    }
                    if (!elem.isClose() || !elem.getName().equals("servlet-class")) continue;
                    servletClassName = parser.getInputFromPositionMarker(elem.getPos()).toString();
                } while (servletClassName == null || !CometdServlet.class.isAssignableFrom(Class.forName(servletClassName)));
                if (servletName != null) {
                    while (!((elem = parser.nextTag()) == null || elem.getName().equals("servlet-mapping") && elem.isOpen())) {
                    }
                    if (elem != null) {
                        String servletNameMapping = null;
                        do {
                            if ((elem = parser.nextTag()).isOpen()) {
                                parser.setPositionMarker();
                                continue;
                            }
                            if (!elem.isClose() || !elem.getName().equals("servlet-name")) continue;
                            servletNameMapping = parser.getInputFromPositionMarker(elem.getPos()).toString();
                        } while (!servletName.equals(servletNameMapping));
                        do {
                            if ((elem = parser.nextTag()).isOpen()) {
                                parser.setPositionMarker();
                                continue;
                            }
                            if (!elem.isClose() || !elem.getName().equals("url-pattern")) continue;
                            urlPattern = parser.getInputFromPositionMarker(elem.getPos()).toString();
                        } while (urlPattern == null);
                    }
                }
            }
            if (urlPattern == null) {
                throw new ServletException("Error searching for cometd Servlet");
            }
            if (!urlPattern.startsWith("/") || !urlPattern.endsWith("/*")) {
                throw new ServletException("Url pattern for cometd should start with / and finish with /*");
            }
            return servletContext.getContextPath() + urlPattern.substring(0, urlPattern.length() - 2);
        }
        catch (Exception ex) {
            String path = servletContext.getContextPath() + "/cometd";
            LOG.warn("Error finding filter cometd servlet in web.xml using default path " + path, (Throwable)ex);
            return path;
        }
    }

    CometdPushBehavior() {
        this._cometdChannelIdWithoutSlash = UUID.randomUUID().toString().replaceAll("-", "");
        this._cometdChannelId = "/" + this._cometdChannelIdWithoutSlash;
    }

    private String _renderEventHandlerScript() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("COMETD_CHANNEL_ID", this._cometdChannelIdWithoutSlash);
        map.put("CALLBACK_URL", this.getCallbackUrl().toString());
        return TEMPLATE_EVENT_HANDLER.asString(map);
    }

    private String _renderInitScript() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isServerWebSocketTransport", CometdPushService.get().isWebSocketTransportAvailable());
        params.put("cometdServletPath", this.getCometdServletPath());
        params.put("logLevel", Application.get().getConfigurationType() == RuntimeConfigurationType.DEVELOPMENT ? "info" : "error");
        return TEMPLATE_INIT.asString(params);
    }

    private String _renderSubscribeScript() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("COMETD_CHANNEL_ID", this._cometdChannelIdWithoutSlash);
        return TEMPLATE_SUBSCRIBE.asString(params);
    }

    <EventType> CometdPushNode<EventType> addNode(IPushEventHandler<EventType> pushEventHandler) {
        CometdPushNode node = new CometdPushNode(this._cometdChannelId);
        this._handlers.put(node, pushEventHandler);
        return node;
    }

    public String getCometdChannelId() {
        return this._cometdChannelId;
    }

    protected String getCometdServletPath() {
        return DEFAULT_COMETD_PATH;
    }

    int removeNode(IPushNode<?> node) {
        this._handlers.remove(node);
        return this._handlers.size();
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COMETD));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COMETD_ACK));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COMETD_RELOAD));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COMETD_TIMESTAMP));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COMETD_TIMESYNC));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this._renderInitScript(), (String)"cometd-push-initialization"));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this._renderEventHandlerScript(), null));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this._renderSubscribeScript(), null));
    }

    protected void respond(AjaxRequestTarget target) {
        CometdPushService pushService = CometdPushService.get();
        for (Map.Entry<CometdPushNode, IPushEventHandler> entry : this._handlers.entrySet()) {
            CometdPushNode node = entry.getKey();
            for (CometdPushEventContext ctx : pushService.pollEvents(node)) {
                try {
                    entry.getValue().onEvent(target, ctx.getEvent(), (IPushNode)node, ctx);
                }
                catch (RuntimeException ex) {
                    LOG.error("Failed while processing event", (Throwable)ex);
                }
            }
        }
    }
}

