/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.cometd;

import java.util.UUID;
import org.wicketstuff.push.IPushNode;

public final class CometdPushNode<T>
implements IPushNode<T> {
    private static final long serialVersionUID = 1L;
    private final String cometdChannelId;
    private final String cometdChannelEventId;
    private final UUID id;
    private final String toString;

    CometdPushNode(String cometdChannelId) {
        this.cometdChannelId = cometdChannelId;
        this.id = UUID.randomUUID();
        this.cometdChannelEventId = this.id.toString().replaceAll("-", "");
        this.toString = this.getClass().getName() + "[cometdChannelId=" + cometdChannelId + ";cometdChannelEventId=" + this.cometdChannelEventId + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CometdPushNode other = (CometdPushNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getCometdChannelEventId() {
        return this.cometdChannelEventId;
    }

    public String getCometdChannelId() {
        return this.cometdChannelId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public String toString() {
        return this.toString;
    }
}

