/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.cometd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.protocol.http.WebApplication;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.push.AbstractPushService;
import org.wicketstuff.push.AbstractPushServiceRef;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.IPushNodeDisconnectedListener;
import org.wicketstuff.push.IPushServiceRef;
import org.wicketstuff.push.PushChannel;
import org.wicketstuff.push.cometd.CometdPushBehavior;
import org.wicketstuff.push.cometd.CometdPushEventContext;
import org.wicketstuff.push.cometd.CometdPushNode;

public class CometdPushService
extends AbstractPushService {
    private static Logger LOG = LoggerFactory.getLogger(CometdPushService.class);
    private static final Map<WebApplication, CometdPushService> INSTANCES = new WeakHashMap<WebApplication, CometdPushService>();
    private static final IPushServiceRef<CometdPushService> PUSH_SERVICE_REF = new AbstractPushServiceRef<CometdPushService>(){
        private static final long serialVersionUID = 1L;

        protected CometdPushService lookupService() {
            return CometdPushService.get();
        }
    };
    private final ConcurrentMap<String, List<CometdPushNode<?>>> _nodesByCometdChannelId = new ConcurrentHashMap();
    private final ConcurrentMap<CometdPushNode<?>, PushNodeState<?>> _nodeStates = new ConcurrentHashMap();
    private final WebApplication _application;
    private BayeuxServer _bayeux;

    public static CometdPushService get() {
        return CometdPushService.get(WebApplication.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CometdPushService get(WebApplication application) {
        Map<WebApplication, CometdPushService> map = INSTANCES;
        synchronized (map) {
            CometdPushService service = INSTANCES.get(application);
            if (service == null) {
                service = new CometdPushService(application);
                INSTANCES.put(application, service);
            }
            return service;
        }
    }

    public static IPushServiceRef<CometdPushService> getRef() {
        return PUSH_SERVICE_REF;
    }

    private CometdPushService(WebApplication application) {
        this._application = application;
        this._getBayeuxServer().addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.ChannelListener(){

            public void channelAdded(ServerChannel channel) {
                LOG.debug("Cometd channel added. channel={}", (Object)channel);
            }

            public void channelRemoved(String channelId) {
                LOG.debug("Cometd channel removed. channel={}", (Object)channelId);
            }

            public void configureChannel(ConfigurableServerChannel channel) {
            }
        });
        this._getBayeuxServer().addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

            public void sessionAdded(ServerSession session, ServerMessage msg) {
                LOG.debug("Cometd server session added. session={}", (Object)session);
            }

            public void sessionRemoved(ServerSession session, boolean timedout) {
                LOG.debug("Cometd server session removed. session={}", (Object)session);
            }
        });
        this._getBayeuxServer().addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SubscriptionListener(){

            public void subscribed(ServerSession session, ServerChannel channel, ServerMessage msg) {
                LOG.debug("Cometd channel subscribe. session={} channel={}", (Object)session, (Object)channel);
            }

            public void unsubscribed(ServerSession session, ServerChannel channel, ServerMessage msg) {
                LOG.debug("Cometd channel unsubscribe. session={}, channel={}", (Object)session, (Object)channel);
                List nodes = (List)CometdPushService.this._nodesByCometdChannelId.remove(channel.getId());
                if (nodes != null) {
                    for (CometdPushNode node : nodes) {
                        CometdPushService.this._onDisconnect(node);
                    }
                }
            }
        });
    }

    private CometdPushBehavior _findPushBehaviour(Component component) {
        for (Behavior behavior : component.getBehaviors()) {
            if (!(behavior instanceof CometdPushBehavior)) continue;
            return (CometdPushBehavior)behavior;
        }
        return null;
    }

    private final synchronized BayeuxServer _getBayeuxServer() {
        if (this._bayeux == null) {
            this._bayeux = (BayeuxServer)this._application.getServletContext().getAttribute("org.cometd.bayeux");
        }
        return this._bayeux;
    }

    private ServerChannel _getBayeuxServerChannel(CometdPushNode<?> node) {
        return this._getBayeuxServer().getChannel(node.getCometdChannelId());
    }

    private <EventType> void _onConnect(CometdPushNode<EventType> node) {
        this._nodeStates.put(node, new PushNodeState<EventType>(node));
        List nodes = (List)this._nodesByCometdChannelId.get(node.getCometdChannelId());
        if (nodes == null) {
            ArrayList<CometdPushNode<EventType>> newList = new ArrayList<CometdPushNode<EventType>>(2);
            nodes = this._nodesByCometdChannelId.putIfAbsent(node.getCometdChannelId(), newList);
            if (nodes == null) {
                newList.add(node);
            } else {
                nodes.add(node);
            }
        }
    }

    private void _onDisconnect(CometdPushNode<?> node) {
        if (this._nodeStates.remove(node) != null) {
            LOG.debug("Cometd push node {} disconnected.", node);
            this.disconnectFromAllChannels(node);
            for (IPushNodeDisconnectedListener listener : this.disconnectListeners) {
                try {
                    listener.onDisconnect(node);
                }
                catch (RuntimeException ex) {
                    LOG.error("Failed to notify " + listener, (Throwable)ex);
                }
            }
        }
    }

    public <EventType> CometdPushNode<EventType> installNode(Component component, IPushEventHandler<EventType> handler) {
        CometdPushBehavior behavior = this._findPushBehaviour(component);
        if (behavior == null) {
            behavior = new CometdPushBehavior();
            component.add(new Behavior[]{behavior});
        }
        CometdPushNode<EventType> node = behavior.addNode(handler);
        this._onConnect(node);
        return node;
    }

    public boolean isConnected(IPushNode<?> node) {
        if (node instanceof CometdPushNode) {
            return this._getBayeuxServerChannel((CometdPushNode)node) != null;
        }
        LOG.warn("Unsupported push node type {}", node);
        return false;
    }

    boolean isWebSocketTransportAvailable() {
        return CometdPushService.get()._getBayeuxServer().getAllowedTransports().contains("websocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <EventType> List<CometdPushEventContext<EventType>> pollEvents(CometdPushNode<EventType> node) {
        PushNodeState state = (PushNodeState)this._nodeStates.get(node);
        if (state == null) {
            LOG.debug("Reconnecting push node {}...", node);
            this._onConnect(node);
            return Collections.EMPTY_LIST;
        }
        if (state.queuedEvents.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Object object = state.queuedEventsLock;
        synchronized (object) {
            List events = state.queuedEvents;
            state.queuedEvents = new ArrayList(2);
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <EventType> void publish(IPushChannel<EventType> channel, EventType event) {
        if (channel == null) {
            throw new IllegalArgumentException("Argument [channel] must not be null");
        }
        Set pnodes = (Set)this.nodesByChannels.get(channel);
        if (pnodes == null) {
            throw new IllegalArgumentException("Unknown channel " + channel);
        }
        CometdPushEventContext<EventType> ctx = new CometdPushEventContext<EventType>(event, channel, this);
        for (IPushNode pnode : pnodes) {
            CometdPushNode node = (CometdPushNode)pnode;
            ServerChannel cchannel = this._getBayeuxServerChannel(node);
            if (cchannel == null) {
                LOG.warn("No cometd channel found for {}", (Object)node);
                continue;
            }
            PushNodeState state = (PushNodeState)this._nodeStates.get(node);
            if (state == null) continue;
            Object object = state.queuedEventsLock;
            synchronized (object) {
                state.queuedEvents.add(ctx);
            }
            cchannel.publish(null, (Object)"pollEvents", Promise.noop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <EventType> void publish(IPushNode<EventType> node, EventType event) {
        if (node instanceof CometdPushNode) {
            ServerChannel cchannel = this._getBayeuxServerChannel((CometdPushNode)node);
            if (cchannel == null) {
                LOG.warn("No cometd channel found for {}", node);
            } else {
                PushNodeState state = (PushNodeState)this._nodeStates.get(node);
                if (state != null) {
                    Object object = state.queuedEventsLock;
                    synchronized (object) {
                        state.queuedEvents.add(new CometdPushEventContext<EventType>(event, null, this));
                    }
                    cchannel.publish(null, (Object)"pollEvents", Promise.noop());
                }
            }
        } else {
            LOG.warn("Unsupported push node type {}", node);
        }
    }

    public <EventType> void publishJavascript(CometdPushNode<EventType> node, String javascript) {
        ServerChannel channel = this._getBayeuxServerChannel(node);
        if (channel == null) {
            LOG.warn("No cometd channel found for {}", node);
        } else {
            channel.publish(null, (Object)("javascript:" + javascript), Promise.noop());
        }
    }

    public <EventType> void publishJavascript(PushChannel<EventType> channel, String javascript) {
        if (channel == null) {
            throw new IllegalArgumentException("Argument [channel] must not be null");
        }
        Set pnodes = (Set)this.nodesByChannels.get(channel);
        if (pnodes == null) {
            throw new IllegalArgumentException("Unknown channel " + channel);
        }
        for (IPushNode node : pnodes) {
            this.publishJavascript((CometdPushNode)node, javascript);
        }
    }

    public void uninstallNode(Component component, IPushNode<?> node) {
        if (node instanceof CometdPushNode) {
            CometdPushBehavior behavior = this._findPushBehaviour(component);
            if (behavior == null) {
                return;
            }
            if (behavior.removeNode(node) == 0) {
                component.remove(new Behavior[]{behavior});
            }
        } else {
            LOG.warn("Unsupported push node type {}", node);
        }
    }

    private static final class PushNodeState<EventType> {
        protected final CometdPushNode<EventType> node;
        protected List<CometdPushEventContext<EventType>> queuedEvents = new ArrayList<CometdPushEventContext<EventType>>(2);
        protected final Object queuedEventsLock = new Object();

        protected PushNodeState(CometdPushNode<EventType> node) {
            this.node = node;
        }
    }
}

