/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushEventContext;

public abstract class AbstractPushEventContext<EventType>
implements IPushEventContext<EventType> {
    private final long timestamp;
    private final IPushChannel<EventType> channel;
    private final EventType event;
    private final Map<Object, Object> properties = new ConcurrentHashMap<Object, Object>();

    protected AbstractPushEventContext(EventType event, IPushChannel<EventType> channel) {
        this.channel = channel;
        this.event = event;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public IPushChannel<EventType> getChannel() {
        return this.channel;
    }

    @Override
    public EventType getEvent() {
        return this.event;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(Args.notNull((Object)key, (String)"key"));
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public AbstractPushEventContext<EventType> setProperty(Object key, Object value) {
        this.properties.put(Args.notNull((Object)key, (String)"key"), value);
        return this;
    }
}

