/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.IPushNodeDisconnectedListener;
import org.wicketstuff.push.IPushService;
import org.wicketstuff.push.PushChannel;

public abstract class AbstractPushService
implements IPushService {
    protected final ConcurrentHashMap<IPushChannel<?>, CopyOnWriteArraySet<IPushNode<?>>> nodesByChannels = new ConcurrentHashMap();
    protected final Set<IPushNodeDisconnectedListener> disconnectListeners = new CopyOnWriteArraySet<IPushNodeDisconnectedListener>();

    @Override
    public void addNodeDisconnectedListener(IPushNodeDisconnectedListener listener) {
        Args.notNull((Object)listener, (String)"listener");
        this.disconnectListeners.add(listener);
    }

    @Override
    public <EventType> void connectToChannel(IPushNode<EventType> node, IPushChannel<EventType> channel) {
        Args.notNull(node, (String)"node");
        Args.notNull(channel, (String)"channel");
        Set pnodes = this.nodesByChannels.get(channel);
        if (pnodes == null) {
            throw new IllegalArgumentException("Unknown channel " + channel);
        }
        pnodes.add(node);
    }

    @Override
    public <EventType> IPushChannel<EventType> createChannel(String label) {
        PushChannel channel = new PushChannel(label);
        this.nodesByChannels.put(channel, new CopyOnWriteArraySet());
        return channel;
    }

    protected void disconnectFromAllChannels(IPushNode<?> node) {
        Args.notNull(node, (String)"node");
        for (Set set : this.nodesByChannels.values()) {
            set.remove(node);
        }
    }

    @Override
    public <EventType> void disconnectFromChannel(IPushNode<EventType> node, IPushChannel<EventType> channel) {
        Args.notNull(node, (String)"node");
        Args.notNull(channel, (String)"channel");
        Set pnodes = this.nodesByChannels.get(channel);
        if (pnodes == null) {
            throw new IllegalArgumentException("Unknown channel " + channel);
        }
        pnodes.remove(node);
    }

    @Override
    public <EventType> void removeChannel(IPushChannel<EventType> channel) {
        Args.notNull(channel, (String)"channel");
        this.nodesByChannels.remove(channel);
    }

    @Override
    public void removeNodeDisconnectedListener(IPushNodeDisconnectedListener listener) {
        Args.notNull((Object)listener, (String)"listener");
        this.disconnectListeners.remove(listener);
    }
}

