/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.examples.chatservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.push.examples.chatservice.IChatListener;
import org.wicketstuff.push.examples.chatservice.Message;

public class ChatRoom {
    private static final Logger LOG = LoggerFactory.getLogger(ChatRoom.class);
    private static final ExecutorService executorService = Executors.newFixedThreadPool(5);
    private final List<Message> chatHistory = new ArrayList();
    private final Set<IChatListener> listeners = new CopyOnWriteArraySet();
    private final String name;

    ChatRoom(String name) {
        this.name = name;
    }

    private void _notify(IChatListener listener, Message message) {
        try {
            listener.onMessage(message);
        }
        catch (Exception ex) {
            LOG.error("Failed to notify chat listener " + listener, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IChatListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public List<Message> getChatHistory() {
        return new ArrayList<Message>(this.chatHistory);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IChatListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void sendAsync(String user, String message) {
        Message msg = new Message(user, message, this.name);
        this.chatHistory.add(msg);
        executorService.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Set access$000(ChatRoom x0) {
        return x0.listeners;
    }

    static /* synthetic */ void access$100(ChatRoom x0, IChatListener x1, Message x2) {
        x0._notify(x1, x2);
    }
}

