/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.examples.pages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.IPushNodeDisconnectedListener;
import org.wicketstuff.push.IPushServiceRef;
import org.wicketstuff.push.examples.ServiceLocator;
import org.wicketstuff.push.examples.chatservice.ChatRoom;
import org.wicketstuff.push.examples.chatservice.IChatListener;
import org.wicketstuff.push.examples.chatservice.Message;

public abstract class WicketAbstractChatPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private String user;
    private String message;
    private AjaxButton sendMessage;

    public WicketAbstractChatPage(PageParameters parameters, String pushImplementationTitle, IPushServiceRef<?> pushServiceRef) {
        super(parameters);
        this.add(new Component[]{new Label("push-implementation-title", (Serializable)((Object)pushImplementationTitle))});
        String chatRoomName = "#wicket-push";
        ChatRoom chatRoom = ServiceLocator.getChatService().getChatRoom("#wicket-push");
        Form formChat = new Form("chatForm", (IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{formChat});
        Label chatHistoryField = new Label("chatHistory", (Serializable)((Object)""));
        chatHistoryField.setEscapeModelStrings(false);
        chatHistoryField.setOutputMarkupId(true);
        formChat.add(new Component[]{chatHistoryField});
        formChat.add(new Component[]{new Label("chatroomName", (Serializable)((Object)"#wicket-push"))});
        formChat.add(new Component[]{new TextField("user")});
        TextField messageField = new TextField("message");
        messageField.setOutputMarkupId(true);
        formChat.add(new Component[]{messageField});
        Component[] componentArray = new Component[1];
        this.sendMessage = new /* Unavailable Anonymous Inner Class!! */;
        componentArray[0] = this.sendMessage;
        formChat.add(componentArray);
        IPushNode pushNode = pushServiceRef.get().installNode((Component)this, (IPushEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        formChat.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        chatRoom.addListener((IChatListener)new /* Unavailable Anonymous Inner Class!! */);
        StringBuilder sb = new StringBuilder();
        for (Message msg : chatRoom.getChatHistory()) {
            sb.append(this._renderMessage(msg));
        }
        chatHistoryField.setDefaultModelObject((Object)sb);
        pushServiceRef.get().addNodeDisconnectedListener((IPushNodeDisconnectedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private String _renderMessage(Message msg) {
        String date = new SimpleDateFormat("h:mm a").format(msg.getDate());
        return date + " <b>" + msg.getUser() + "</b>" + " said" + " <b>" + msg.getMessage() + "</b><br>";
    }

    static /* synthetic */ String access$000(WicketAbstractChatPage x0) {
        return x0.user;
    }

    static /* synthetic */ String access$100(WicketAbstractChatPage x0) {
        return x0.message;
    }

    static /* synthetic */ String access$200(WicketAbstractChatPage x0, Message x1) {
        return x0._renderMessage(x1);
    }

    static /* synthetic */ AjaxButton access$300(WicketAbstractChatPage x0) {
        return x0.sendMessage;
    }
}

