/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.timer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.push.AbstractPushService;
import org.wicketstuff.push.AbstractPushServiceRef;
import org.wicketstuff.push.IPushChannel;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.IPushNodeDisconnectedListener;
import org.wicketstuff.push.IPushServiceRef;
import org.wicketstuff.push.timer.TimerPushBehavior;
import org.wicketstuff.push.timer.TimerPushEventContext;
import org.wicketstuff.push.timer.TimerPushNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerPushService
extends AbstractPushService {
    private static final Logger LOG = LoggerFactory.getLogger(TimerPushService.class);
    private static final ConcurrentHashMap<Application, TimerPushService> INSTANCES = new ConcurrentHashMap(2);
    private static final IPushServiceRef<TimerPushService> PUSH_SERVICE_REF = new AbstractPushServiceRef<TimerPushService>(){
        private static final long serialVersionUID = 1L;

        protected TimerPushService lookupService() {
            return TimerPushService.get();
        }
    };
    private Duration _defaultPollingInterval = Duration.seconds((int)2);
    private Duration _maxTimeLag = Duration.seconds((int)10);
    private final ConcurrentMap<TimerPushNode<?>, PushNodeState<?>> _nodeStates = new ConcurrentHashMap();
    private final ScheduledThreadPoolExecutor _cleanupExecutor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture<?> _cleanupFuture = null;
    private final Runnable _cleanupTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.debug("Running timer push node cleanup task...");
            int count = 0;
            Iterator i$ = TimerPushService.this._nodeStates.values().iterator();
            while (i$.hasNext()) {
                PushNodeState state;
                PushNodeState pushNodeState = state = (PushNodeState)i$.next();
                synchronized (pushNodeState) {
                    if (state.isTimedOut()) {
                        TimerPushService.this.onDisconnect(state.node);
                        ++count;
                    }
                }
            }
            LOG.debug("Cleaned up {} timer push nodes.", (Object)count);
        }
    };

    public static TimerPushService get() {
        return TimerPushService.get(Application.get());
    }

    public static TimerPushService get(Application application) {
        Args.notNull((Object)application, (String)"application");
        TimerPushService service = INSTANCES.get(application);
        if (service == null) {
            service = new TimerPushService();
            TimerPushService existingInstance = INSTANCES.putIfAbsent(application, service);
            if (existingInstance == null) {
                service.setCleanupInterval(Duration.seconds((int)60));
            } else {
                service = existingInstance;
            }
        }
        return service;
    }

    public static IPushServiceRef<TimerPushService> getRef() {
        return PUSH_SERVICE_REF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onApplicationShutdown(Application application) {
        Args.notNull((Object)application, (String)"application");
        TimerPushService srv = INSTANCES.remove(application);
        if (srv != null) {
            LOG.info("Shutting down {}...", (Object)srv);
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = srv._cleanupExecutor;
            synchronized (scheduledThreadPoolExecutor) {
                srv._cleanupFuture.cancel(false);
                srv._cleanupFuture = null;
                srv._cleanupExecutor.shutdownNow();
            }
        }
    }

    private TimerPushService() {
    }

    private TimerPushBehavior _findPushBehaviour(Component component) {
        for (Behavior behavior : component.getBehaviors()) {
            if (!(behavior instanceof TimerPushBehavior)) continue;
            return (TimerPushBehavior)behavior;
        }
        return null;
    }

    private <EventType> void _onConnect(TimerPushNode<EventType> node) {
        this._nodeStates.put(node, new PushNodeState<EventType>(node));
    }

    public Duration getDefaultPollingInterval() {
        return this._defaultPollingInterval;
    }

    public Duration getMaxTimeLag() {
        return this._maxTimeLag;
    }

    public <EventType> TimerPushNode<EventType> installNode(Component component, IPushEventHandler<EventType> handler) {
        return this.installNode(component, handler, this._defaultPollingInterval);
    }

    public <EventType> TimerPushNode<EventType> installNode(Component component, IPushEventHandler<EventType> handler, Duration pollingInterval) {
        Args.notNull((Object)component, (String)"component");
        Args.notNull(handler, (String)"handler");
        Args.notNull((Object)pollingInterval, (String)"pollingInterval");
        TimerPushBehavior behavior = this._findPushBehaviour(component);
        if (behavior != null && behavior.isStopped()) {
            component.remove(new Behavior[]{behavior});
            behavior = null;
        }
        if (behavior == null) {
            behavior = new TimerPushBehavior(pollingInterval);
            component.add(new Behavior[]{behavior});
        }
        TimerPushNode<EventType> node = behavior.addNode(handler, pollingInterval);
        this._onConnect(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(IPushNode<?> node) {
        Args.notNull(node, (String)"node");
        if (node instanceof TimerPushNode) {
            PushNodeState state = (PushNodeState)this._nodeStates.get(node);
            if (state == null) {
                return false;
            }
            PushNodeState pushNodeState = state;
            synchronized (pushNodeState) {
                if (state.isTimedOut()) {
                    this.onDisconnect(state.node);
                    return false;
                }
            }
            return true;
        }
        LOG.warn("Unsupported push node type {}", node);
        return false;
    }

    void onDisconnect(TimerPushNode<?> node) {
        if (this._nodeStates.remove(node) != null) {
            LOG.debug("Timer push node {} disconnected.", node);
            this.disconnectFromAllChannels(node);
            for (IPushNodeDisconnectedListener listener : this.disconnectListeners) {
                try {
                    listener.onDisconnect(node);
                }
                catch (RuntimeException ex) {
                    LOG.error("Failed to notify " + listener, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <EventType> List<TimerPushEventContext<EventType>> pollEvents(TimerPushNode<EventType> node) {
        PushNodeState state = (PushNodeState)this._nodeStates.get(node);
        if (state == null) {
            LOG.debug("Reconnecting push node {}...", node);
            this._onConnect(node);
            return Collections.EMPTY_LIST;
        }
        PushNodeState pushNodeState = state;
        synchronized (pushNodeState) {
            state.lastPolledAt = Time.now();
            if (state.queuedEvents.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            List events = state.queuedEvents;
            state.queuedEvents = new ArrayList(2);
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <EventType> void publish(IPushChannel<EventType> channel, EventType event) {
        Args.notNull(channel, (String)"channel");
        Set pnodes = (Set)this.nodesByChannels.get(channel);
        if (pnodes == null) {
            throw new IllegalArgumentException("Unknown channel " + channel);
        }
        TimerPushEventContext<EventType> ctx = new TimerPushEventContext<EventType>(event, channel, this);
        for (IPushNode pnode : pnodes) {
            PushNodeState state;
            TimerPushNode node = (TimerPushNode)pnode;
            if (!this.isConnected(node) || (state = (PushNodeState)this._nodeStates.get(node)) == null) continue;
            PushNodeState pushNodeState = state;
            synchronized (pushNodeState) {
                state.queuedEvents.add(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <EventType> void publish(IPushNode<EventType> node, EventType event) {
        Args.notNull(node, (String)"node");
        if (node instanceof TimerPushNode) {
            PushNodeState state;
            if (this.isConnected(node) && (state = (PushNodeState)this._nodeStates.get(node)) != null) {
                PushNodeState pushNodeState = state;
                synchronized (pushNodeState) {
                    state.queuedEvents.add(new TimerPushEventContext<EventType>(event, null, this));
                }
            }
        } else {
            LOG.warn("Unsupported push node type {}", node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupInterval(Duration interval) {
        Args.notNull((Object)interval, (String)"interval");
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this._cleanupExecutor;
        synchronized (scheduledThreadPoolExecutor) {
            if (this._cleanupFuture != null) {
                this._cleanupFuture.cancel(false);
            }
            if (!this._cleanupExecutor.isShutdown()) {
                this._cleanupFuture = this._cleanupExecutor.scheduleAtFixedRate(this._cleanupTask, interval.getMilliseconds(), interval.getMilliseconds(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public void setDefaultPollingInterval(Duration defaultPollingInterval) {
        Args.notNull((Object)defaultPollingInterval, (String)"defaultPollingInterval");
        this._defaultPollingInterval = defaultPollingInterval;
    }

    public void setMaxTimeLag(Duration maxTimeLag) {
        Args.notNull((Object)maxTimeLag, (String)"maxTimeLag");
        this._maxTimeLag = maxTimeLag;
    }

    public void uninstallNode(Component component, IPushNode<?> node) {
        Args.notNull((Object)component, (String)"component");
        Args.notNull(node, (String)"node");
        if (node instanceof TimerPushNode) {
            TimerPushBehavior behavior = this._findPushBehaviour(component);
            if (behavior == null) {
                return;
            }
            if (behavior.removeNode(node) == 0) {
                behavior.stop();
            }
        } else {
            LOG.warn("Unsupported push node type {}", node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PushNodeState<EventType> {
        final TimerPushNode<EventType> node;
        Time lastPolledAt = Time.now();
        List<TimerPushEventContext<EventType>> queuedEvents = new ArrayList<TimerPushEventContext<EventType>>(2);

        PushNodeState(TimerPushNode<EventType> node) {
            this.node = node;
        }

        boolean isTimedOut() {
            return Time.now().subtract(this.lastPolledAt).greaterThan((LongValue)TimerPushService.this._maxTimeLag);
        }
    }
}

