/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.push.timer;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.push.IPushEventContext;
import org.wicketstuff.push.IPushEventHandler;
import org.wicketstuff.push.IPushNode;
import org.wicketstuff.push.timer.TimerPushNode;
import org.wicketstuff.push.timer.TimerPushService;

public class TimerPushBehavior
extends AbstractAjaxTimerBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TimerPushBehavior.class);
    private final Map<TimerPushNode, IPushEventHandler> handlers = new HashMap<TimerPushNode, IPushEventHandler>(2);

    TimerPushBehavior(Duration pollingInterval) {
        super(pollingInterval);
    }

    <EventType> TimerPushNode<EventType> addNode(IPushEventHandler<EventType> pushEventHandler, Duration pollingInterval) {
        if (pollingInterval.lessThan((LongValue)this.getUpdateInterval())) {
            this.setUpdateInterval(pollingInterval);
        }
        TimerPushNode node = new TimerPushNode(pollingInterval);
        this.handlers.put(node, pushEventHandler);
        return node;
    }

    protected void onTimer(AjaxRequestTarget target) {
        if (this.isStopped()) {
            this.getComponent().remove(new Behavior[]{this});
            return;
        }
        TimerPushService pushService = TimerPushService.get(target.getPage().getApplication());
        WebRequest request = (WebRequest)RequestCycle.get().getRequest();
        if (!request.getRequestParameters().getParameterValue("unload").isNull()) {
            for (TimerPushNode node : this.handlers.keySet()) {
                pushService.onDisconnect(node);
            }
        } else {
            for (Map.Entry<TimerPushNode, IPushEventHandler> entry : this.handlers.entrySet()) {
                TimerPushNode node = entry.getKey();
                for (IPushEventContext iPushEventContext : pushService.pollEvents(node)) {
                    try {
                        entry.getValue().onEvent(target, iPushEventContext.getEvent(), (IPushNode)node, iPushEventContext);
                    }
                    catch (RuntimeException ex) {
                        LOG.error("Failed while processing event", (Throwable)ex);
                    }
                }
            }
        }
    }

    int removeNode(IPushNode<?> node) {
        this.handlers.remove(node);
        Duration newPollingInterval = Duration.MAXIMUM;
        for (TimerPushNode n : this.handlers.keySet()) {
            if (!n.getPollingInterval().lessThan((LongValue)newPollingInterval)) continue;
            newPollingInterval = n.getPollingInterval();
        }
        this.setUpdateInterval(newPollingInterval);
        return this.handlers.size();
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        if (!this.isStopped()) {
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"history.navigationMode = 'compatible';", (String)"Opera on-unload support"));
            response.render((HeaderItem)OnEventHeaderItem.forScript((String)"window", (String)"unload", (CharSequence)("Wicket.Ajax.get({'u': '" + this.getCallbackUrl().toString() + "&unload=1'});")));
        }
    }
}

