/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.security.hive.Hive;
import org.wicketstuff.security.hive.authentication.Subject;
import org.wicketstuff.security.hive.authorization.Permission;
import org.wicketstuff.security.hive.authorization.Principal;
import org.wicketstuff.security.util.ManyToManyMap;

public class BasicHive
implements Hive {
    private static final Logger log = LoggerFactory.getLogger(BasicHive.class);
    private ManyToManyMap<Permission, Principal> principals = new ManyToManyMap(500);
    private boolean locked = false;

    public final void lock() {
        this.locked = true;
        if (log.isDebugEnabled()) {
            log.debug("Locking Hive, permissions can not be added anymore.");
        }
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final void addPrincipal(Principal principal, Collection<Permission> permissions) {
        if (this.isLocked()) {
            throw new IllegalStateException("While the hive is locked no changes are allowed.");
        }
        if (principal == null) {
            throw new IllegalArgumentException("A principal is required.");
        }
        if (permissions == null) {
            throw new IllegalArgumentException("At least one permission is required for principal " + principal);
        }
        boolean debug = log.isDebugEnabled();
        for (Permission next : permissions) {
            this.principals.add(next, principal);
            if (!debug) continue;
            log.debug("Adding " + next + " to " + principal);
        }
    }

    public final void addPermission(Principal principal, Permission permission) {
        if (this.isLocked()) {
            throw new IllegalStateException("While the hive is locked no changes are allowed.");
        }
        if (principal == null) {
            throw new IllegalArgumentException("A principal is required.");
        }
        if (permission == null) {
            throw new IllegalArgumentException("A permission is required.");
        }
        this.principals.add(permission, principal);
        if (log.isDebugEnabled()) {
            log.debug("Adding " + permission + " to " + principal);
        }
    }

    @Override
    public final boolean containsPrincipal(Principal principal) {
        return this.principals.containsRight(principal);
    }

    protected Boolean cacheLookUp(Subject subject, Permission permission) {
        return null;
    }

    protected void cacheResult(Subject subject, Permission permission, boolean result) {
    }

    @Override
    public final boolean hasPermission(Subject subject, Permission permission) {
        Boolean cacheResult = this.cacheLookUp(subject, permission);
        if (cacheResult != null) {
            if (log.isDebugEnabled()) {
                log.debug(subject + " has a cached match for " + permission + ", result " + cacheResult);
            }
            return cacheResult;
        }
        if (this.hasPrincipal(subject, this.principals.getRight(permission))) {
            if (log.isDebugEnabled()) {
                log.debug(subject + " has an exact match for " + permission);
            }
            this.cacheResult(subject, permission, true);
            return true;
        }
        Iterator<Permission> it = this.principals.leftIterator();
        while (it.hasNext()) {
            Permission possibleMatch = it.next();
            if (!possibleMatch.implies(permission) || !this.hasPrincipal(subject, this.principals.getRight(possibleMatch))) continue;
            if (log.isDebugEnabled()) {
                log.debug(subject + " implies " + permission);
            }
            this.cacheResult(subject, permission, true);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(subject + " does not have or implies " + permission);
        }
        this.cacheResult(subject, permission, false);
        return false;
    }

    private final boolean hasPrincipal(Subject subject, Set<Principal> principalSet) {
        if (!principalSet.isEmpty()) {
            Set<Object> subjectPrincipals = subject == null ? Collections.emptySet() : subject.getPrincipals();
            for (Principal curPrincipal : principalSet) {
                if (!subjectPrincipals.contains(curPrincipal) && !curPrincipal.implies(subject)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean containsPermission(Permission permission) {
        return this.principals.containsLeft(permission);
    }

    @Override
    public final Set<Permission> getPermissions(Principal principal) {
        Set<Permission> set = this.principals.getLeft(principal);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public final Set<Principal> getPrincipals(Permission permission) {
        Set<Principal> set = this.principals.getRight(permission);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }
}

