/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.wicketstuff.security.hive.BasicHive;
import org.wicketstuff.security.hive.authentication.Subject;
import org.wicketstuff.security.hive.authorization.Permission;

public class SimpleCachingHive
extends BasicHive {
    private final WeakHashMap<Subject, Map<Permission, Boolean>> cache = new WeakHashMap(50);

    @Override
    protected Boolean cacheLookUp(Subject subject, Permission permission) {
        if (subject == null || permission == null) {
            return null;
        }
        Map<Permission, Boolean> result = this.cache.get(subject);
        if (result != null) {
            return result.get(permission);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cacheResult(Subject subject, Permission permission, boolean result) {
        if (subject == null || permission == null) {
            return;
        }
        Map<Permission, Boolean> resultMap = this.cache.get(subject);
        if (resultMap == null) {
            resultMap = new ConcurrentHashMap<Permission, Boolean>();
            resultMap.put(permission, result);
            WeakHashMap<Subject, Map<Permission, Boolean>> weakHashMap = this.cache;
            synchronized (weakHashMap) {
                this.cache.put(subject, resultMap);
            }
        } else {
            resultMap.put(permission, result);
        }
    }
}

