/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive.authentication;

import org.wicketstuff.security.authentication.LoginException;
import org.wicketstuff.security.hive.authentication.LoginContext;
import org.wicketstuff.security.hive.authentication.Subject;

public abstract class UsernamePasswordContext
extends LoginContext {
    private String username;
    private String password;

    public UsernamePasswordContext() {
        this.username = null;
        this.password = null;
    }

    public UsernamePasswordContext(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected UsernamePasswordContext(int sortOrder, boolean allowAdditionalLogins) {
        super(sortOrder, allowAdditionalLogins);
        this.username = null;
        this.password = null;
    }

    protected UsernamePasswordContext(String username, String password, int sortOrder, boolean allowAdditionalLogins) {
        super(sortOrder, allowAdditionalLogins);
        this.username = username;
        this.password = password;
    }

    @Override
    public final Subject login() throws LoginException {
        if (this.username == null || this.password == null) {
            throw new LoginException("Insufficient information to login");
        }
        Subject subject = this.getSubject(this.username, this.password);
        this.username = null;
        this.password = null;
        return subject;
    }

    protected abstract Subject getSubject(String var1, String var2) throws LoginException;
}

