/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive.authorization.permissions;

import org.wicketstuff.security.actions.Inherit;
import org.wicketstuff.security.actions.WaspAction;
import org.wicketstuff.security.hive.authorization.Permission;

public class ActionPermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private WaspAction actions;

    protected ActionPermission(String name, WaspAction actions) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Name is required.");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions is required.");
        }
        this.actions = actions;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof ActionPermission) {
            ActionPermission other = (ActionPermission)permission;
            if (this.actions.implies(this.actions.getActionFactory().getAction(Inherit.class))) {
                return this.actions.implies(other.actions) && other.getName().startsWith(this.getName());
            }
            return this.actions.implies(other.actions) && this.getName().equals(other.getName());
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ActionPermission other = (ActionPermission)obj;
            return other.getName().equals(this.getName()) && other.actions.equals(this.actions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 4679;
        result = 37 * result + this.getClass().getName().hashCode();
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.actions.hashCode();
        return result;
    }

    @Override
    public final String getActions() {
        return this.actions.getName();
    }

    public String toString() {
        return this.getClass().getName() + " \"" + this.getName() + "\" \"" + this.getActions() + "\"";
    }

    protected final WaspAction getAction() {
        return this.actions;
    }
}

