/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.security.actions.ActionFactory;
import org.wicketstuff.security.actions.WaspAction;
import org.wicketstuff.security.hive.BasicHive;
import org.wicketstuff.security.hive.Hive;
import org.wicketstuff.security.hive.SimpleCachingHive;
import org.wicketstuff.security.hive.authorization.EverybodyPrincipal;
import org.wicketstuff.security.hive.authorization.Permission;
import org.wicketstuff.security.hive.authorization.Principal;
import org.wicketstuff.security.hive.config.HiveFactory;

public class PolicyFileHiveFactory
implements HiveFactory {
    private static final Logger log = LoggerFactory.getLogger(PolicyFileHiveFactory.class);
    private Set<URL> policyFiles;
    private Set<InputStream> inputStreams;
    private Set<Reader> inputReaders;
    private static final Pattern principalPattern = Pattern.compile("\\s*(?:grant(?:\\s+principal\\s+([^\"]+)\\s+\"([^\"]+)\")?){1}\\s*");
    private static final Pattern permissionPattern = Pattern.compile("\\s*(?:permission\\s+([^\",]+?)\\s+(?:(?:\"([^\"]+)\"){1}?(?:\\s*,\\s*\"([^\"]*)\")?)?\\s*;){1}\\s*");
    private static final Pattern aliasPattern = Pattern.compile("(\\$\\{[^\"\\{\\}\\$]+?\\})+?");
    private static final Class<?>[][] constructorArgs = new Class[][]{{String.class, WaspAction.class}, {String.class, String.class}, {String.class, ActionFactory.class}, {String.class}};
    private Map<String, String> aliases = new HashMap<String, String>();
    private boolean useHiveCache = true;
    private boolean closeInputStreams = true;
    private int currentLineNr;
    private final ActionFactory actionFactory;

    public PolicyFileHiveFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
        if (actionFactory == null) {
            throw new IllegalArgumentException("Must provide an ActionFactory");
        }
        this.policyFiles = new HashSet<URL>();
        this.inputStreams = new HashSet<InputStream>();
        this.inputReaders = new HashSet<Reader>();
        this.setAlias("AllPermissions", "org.wicketstuff.security.hive.authorization.permissions.AllPermissions");
    }

    public final boolean addPolicyFile(URL file) {
        if (file == null) {
            log.warn("Can not add null as an url.");
            return false;
        }
        return this.policyFiles.add(file);
    }

    protected final Set<URL> getPolicyFiles() {
        return Collections.unmodifiableSet(this.policyFiles);
    }

    public final boolean addStream(InputStream stream) {
        if (stream == null) {
            log.warn("Can not add null as a stream.");
            return false;
        }
        return this.inputStreams.add(stream);
    }

    protected final Set<InputStream> getStreams() {
        return Collections.unmodifiableSet(this.inputStreams);
    }

    public final boolean addReader(Reader input) {
        if (input == null) {
            log.warn("Can not add null as a reader.");
            return false;
        }
        return this.inputReaders.add(input);
    }

    protected final Set<Reader> getReaders() {
        return Collections.unmodifiableSet(this.inputReaders);
    }

    public final String getAlias(String key) {
        return this.aliases.get(key);
    }

    public final String setAlias(String key, String value) {
        return this.aliases.put(key, value);
    }

    protected final int getCurrentLineNr() {
        return this.currentLineNr;
    }

    private String resolveAliases(String raw) {
        String temp;
        Matcher m = aliasPattern.matcher(raw);
        StringBuffer buff = new StringBuffer(raw.length() + 30);
        int index = 0;
        while (m.find()) {
            if (m.start() > index) {
                buff.append(raw.substring(index, m.start()));
                this.replaceAlias(raw, m, buff);
            } else if (m.start() == index) {
                this.replaceAlias(raw, m, buff);
            } else {
                throw new IllegalStateException("These aliases are not supported: " + raw);
            }
            index = m.end();
        }
        if (index < raw.length()) {
            buff.append(raw.substring(index, raw.length()));
        }
        if ((temp = buff.toString()).indexOf("${") >= 0) {
            throw new IllegalStateException("Nesting aliases is not supported: " + raw);
        }
        return temp;
    }

    private void replaceAlias(String raw, Matcher m, StringBuffer buff) {
        String key = raw.substring(m.start() + 2, m.end() - 1);
        String alias = this.getAlias(key);
        if (alias == null) {
            alias = key;
            if (log.isDebugEnabled()) {
                log.debug("failed to resolve alias: " + key);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("resolved alias: " + key + " to " + alias);
        }
        buff.ensureCapacity(buff.length() + alias.length());
        buff.append(alias);
    }

    protected BasicHive constructHive() {
        if (this.isUsingHiveCache()) {
            return new SimpleCachingHive();
        }
        return new BasicHive();
    }

    @Override
    public final Hive createHive() {
        BasicHive hive = this.constructHive();
        boolean readAnything = false;
        for (URL uRL : this.policyFiles) {
            readAnything = true;
            try {
                this.readPolicyFile(uRL, hive);
            }
            catch (IOException e) {
                log.error("Could not read from " + uRL, (Throwable)e);
            }
        }
        for (InputStream inputStream : this.inputStreams) {
            readAnything = true;
            try {
                this.readInputStream(inputStream, hive);
            }
            catch (IOException e) {
                log.error("Could not read from stream", (Throwable)e);
            }
        }
        this.inputStreams.clear();
        for (Reader reader : this.inputReaders) {
            readAnything = true;
            try {
                this.readInputReader(reader, hive);
            }
            catch (IOException e) {
                log.error("Could not read from reader", (Throwable)e);
            }
        }
        this.inputReaders.clear();
        if (!readAnything) {
            log.warn("No policyFiles or inputstreams were added to the factory!");
        }
        hive.lock();
        return hive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void readPolicyFile(URL file, BasicHive hive) throws IOException {
        this.notifyFileStart(file);
        InputStream stream = null;
        try {
            stream = file.openStream();
            this.readStream(stream, hive);
        }
        finally {
            this.notifyFileClose(file, this.currentLineNr);
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected final void readInputStream(InputStream stream, BasicHive hive) throws IOException {
        this.notifyStreamStart(stream);
        try {
            this.readStream(stream, hive);
        }
        finally {
            this.notifyStreamEnd(stream, this.currentLineNr);
            if (this.closeInputStreams) {
                stream.close();
            }
        }
    }

    protected final void readInputReader(Reader input, BasicHive hive) throws IOException {
        this.notifyReaderStart(input);
        try {
            this.readReader(input, hive);
        }
        finally {
            this.notifyReaderEnd(input, this.currentLineNr);
            if (this.closeInputStreams) {
                input.close();
            }
        }
    }

    protected void readReader(Reader input, BasicHive hive) throws IOException {
        this.read(input, hive);
    }

    protected void notifyStreamEnd(InputStream stream, int lineNr) {
    }

    protected void notifyReaderStart(Reader input) {
    }

    protected void notifyReaderEnd(Reader input, int lineNr) {
    }

    protected void notifyStreamStart(InputStream stream) {
    }

    protected void readStream(InputStream input, BasicHive hive) throws IOException {
        this.read(new InputStreamReader(input), hive);
    }

    protected final void read(Reader input, BasicHive hive) throws IOException {
        BufferedReader reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        boolean inPrincipalBlock = false;
        Principal principal = null;
        HashSet<Permission> permissions = null;
        this.currentLineNr = 0;
        String line = reader.readLine();
        while (line != null) {
            block34: {
                ++this.currentLineNr;
                if (inPrincipalBlock) {
                    boolean endsWith;
                    String trim = line.trim();
                    boolean startsWith = trim.startsWith("{");
                    if (startsWith) {
                        if (permissions != null || principal == null) {
                            this.skipIllegalPrincipal(this.currentLineNr, principal, permissions);
                        }
                        permissions = new HashSet<Permission>();
                    }
                    if (endsWith = trim.endsWith("};")) {
                        inPrincipalBlock = false;
                        if (permissions != null && permissions.size() > 0) {
                            hive.addPrincipal(principal, permissions);
                        } else {
                            this.skipEmptyPrincipal(this.currentLineNr, principal);
                        }
                        permissions = null;
                        principal = null;
                    }
                    if (!startsWith && !endsWith) {
                        Matcher m = permissionPattern.matcher(line);
                        if (m.matches()) {
                            String classname = m.group(1);
                            if (classname == null) {
                                this.skipPermission(this.currentLineNr, null);
                                line = reader.readLine();
                                continue;
                            }
                            try {
                                Class<?> permissionClass = Class.forName(this.resolveAliases(classname));
                                if (!Permission.class.isAssignableFrom(permissionClass)) {
                                    this.skipPermission(this.currentLineNr, permissionClass);
                                    line = reader.readLine();
                                    continue;
                                }
                                String name = this.resolveAliases(m.group(2));
                                String actions = m.group(3);
                                Permission temp = this.createPermission(permissionClass.asSubclass(Permission.class), name, actions);
                                if (temp == null) {
                                    line = reader.readLine();
                                    continue;
                                }
                                if (permissions == null) {
                                    this.skipIllegalPermission(this.currentLineNr, principal, temp);
                                    line = reader.readLine();
                                    continue;
                                }
                                if (!permissions.add(temp)) {
                                    this.skipPermission(this.currentLineNr, principal, temp);
                                } else {
                                    this.notifyPermission(this.currentLineNr, principal, temp);
                                }
                                break block34;
                            }
                            catch (ClassNotFoundException e) {
                                this.skipPermission(this.currentLineNr, classname, e);
                                line = reader.readLine();
                                continue;
                            }
                        }
                        this.skipLine(this.currentLineNr, line);
                    }
                } else {
                    Matcher m = principalPattern.matcher(line);
                    if (m.matches()) {
                        block35: {
                            String classname = m.group(1);
                            if (classname == null) {
                                principal = new EverybodyPrincipal();
                            } else {
                                try {
                                    Class<?> readPrincipalClass = Class.forName(this.resolveAliases(classname));
                                    if (!Principal.class.isAssignableFrom(readPrincipalClass)) {
                                        this.skipPrincipalClass(this.currentLineNr, readPrincipalClass);
                                        line = reader.readLine();
                                        continue;
                                    }
                                    Class<Principal> principalClass = readPrincipalClass.asSubclass(Principal.class);
                                    Constructor<Principal> constructor = null;
                                    try {
                                        constructor = principalClass.getConstructor(constructorArgs[constructorArgs.length - 1]);
                                    }
                                    catch (SecurityException e) {
                                        log.error("No valid constructor found for " + principalClass.getName(), (Throwable)e);
                                    }
                                    catch (NoSuchMethodException e) {
                                        log.error("No valid constructor found for " + principalClass.getName(), (Throwable)e);
                                    }
                                    if (constructor == null) {
                                        this.skipPrincipal(this.currentLineNr, principalClass);
                                        line = reader.readLine();
                                        continue;
                                    }
                                    try {
                                        principal = constructor.newInstance(this.resolveAliases(m.group(2)));
                                        break block35;
                                    }
                                    catch (Exception e) {
                                        this.skipPrincipal(this.currentLineNr, principalClass, e);
                                        line = reader.readLine();
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    this.skipPrincipalClass(this.currentLineNr, classname, e);
                                    line = reader.readLine();
                                }
                                continue;
                            }
                        }
                        this.notifyOfPrincipal(this.currentLineNr, principal);
                        inPrincipalBlock = true;
                    } else {
                        this.skipLine(this.currentLineNr, line);
                    }
                }
            }
            line = reader.readLine();
        }
        if (inPrincipalBlock) {
            this.warnUnclosedPrincipalBlock(principal, this.currentLineNr);
            inPrincipalBlock = false;
            if (permissions != null && permissions.size() > 0) {
                hive.addPrincipal(principal, (Collection<Permission>)permissions);
            } else {
                this.skipEmptyPrincipal(this.currentLineNr, principal);
            }
            permissions = null;
            principal = null;
        }
    }

    private Permission createPermission(Class<? extends Permission> permissionClass, String name, String actions) {
        Constructor<? extends Permission> constructor = this.findConstructor(permissionClass, actions);
        if (constructor == null) {
            this.skipPermission(this.currentLineNr, permissionClass);
            return null;
        }
        Object[] argValues = null;
        if (this.match(constructor.getParameterTypes(), constructorArgs[0])) {
            argValues = new Object[]{name, this.getActionFactory().getAction(actions)};
        } else if (this.match(constructor.getParameterTypes(), constructorArgs[1])) {
            argValues = new Object[]{name, actions};
        } else if (this.match(constructor.getParameterTypes(), constructorArgs[2])) {
            argValues = new Object[]{name, this.actionFactory};
        } else if (this.match(constructor.getParameterTypes(), constructorArgs[3])) {
            argValues = new Object[]{name};
        } else {
            String msg = "Unable to handle constructor " + constructor + ", at line nr " + this.currentLineNr;
            log.error(msg);
            throw new RuntimeException(msg);
        }
        try {
            return constructor.newInstance(argValues);
        }
        catch (Exception e) {
            this.skipPermission(this.currentLineNr, permissionClass, argValues, e);
            return null;
        }
    }

    private boolean match(Class<?>[] args1, Class<?>[] args2) {
        if (args1 == args2) {
            return true;
        }
        if (args1 == null || args2 == null) {
            return false;
        }
        if (args1.length != args2.length) {
            return false;
        }
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i].isAssignableFrom(args2[i])) continue;
            return false;
        }
        return true;
    }

    private Constructor<? extends Permission> findConstructor(Class<? extends Permission> permissionClass, String actions) {
        int index = 0;
        if (actions == null) {
            index = 2;
        }
        return this.findConstructor(permissionClass, index);
    }

    private Constructor<? extends Permission> findConstructor(Class<? extends Permission> permissionClass, int index) {
        Constructor<? extends Permission> constructor;
        block5: {
            if (index >= constructorArgs.length) {
                return null;
            }
            Class<?>[] args = constructorArgs[index];
            constructor = null;
            try {
                constructor = permissionClass.getConstructor(args);
            }
            catch (SecurityException e) {
                log.debug("No valid constructor found for " + permissionClass.getName(), (Throwable)e);
                this.notifyPermission(this.currentLineNr, permissionClass, args);
                if (index < constructorArgs.length) {
                    return this.findConstructor(permissionClass, index + 1);
                }
            }
            catch (NoSuchMethodException e) {
                log.debug("No valid constructor found for " + permissionClass.getName(), (Throwable)e);
                this.notifyPermission(this.currentLineNr, permissionClass, args);
                if (index >= constructorArgs.length) break block5;
                return this.findConstructor(permissionClass, index + 1);
            }
        }
        return constructor;
    }

    protected void warnUnclosedPrincipalBlock(Principal principal, int lineNr) {
        log.warn("The principal " + principal + " running to line " + lineNr + " is not properly closed with '};'.");
    }

    protected void notifyFileClose(URL file, int lineNr) {
    }

    protected void notifyFileStart(URL file) {
    }

    protected void skipPermission(int lineNr, String classname, ClassNotFoundException e) {
        log.error("Permission class not found: " + classname + ", line " + lineNr, (Throwable)e);
    }

    protected void notifyPermission(int lineNr, Principal principal, Permission permission) {
    }

    protected void skipPermission(int lineNr, Principal principal, Permission permission) {
        log.debug(permission + " skipped because it was already added to the permission set for " + principal + ", line nr " + lineNr);
    }

    protected void skipIllegalPermission(int lineNr, Principal principal, Permission permission) {
        log.debug(permission + " skipped because the pricipal " + principal + " has not yet declared its opening block statement '{', line nr " + lineNr);
    }

    protected void skipPrincipalClass(int lineNr, String classname, ClassNotFoundException e) {
        log.error("Unable to find principal of class " + classname + " at line nr " + lineNr, (Throwable)e);
    }

    protected void skipPrincipal(int lineNr, Class<? extends Principal> principalClass) {
        log.error("No valid constructor found for " + principalClass.getName() + " at line " + lineNr);
    }

    protected void notifyOfPrincipal(int lineNr, Principal principal) {
    }

    protected void skipPrincipal(int lineNr, Class<? extends Principal> principalClass, Exception e) {
        log.error("Unable to create new instance of " + principalClass.getName() + " at line nr " + lineNr, (Throwable)e);
    }

    protected void skipPrincipalClass(int lineNr, Class<?> principalClass) {
        log.error(principalClass.getName() + "is not a subclass of " + Principal.class.getName() + ", line nr " + lineNr);
    }

    protected void skipLine(int lineNr, String line) {
        log.debug("skipping line " + lineNr + ": " + line);
    }

    protected void skipPermission(int lineNr, Class<? extends Permission> permissionClass, Object[] argValues, Exception e) {
        log.error("Unable to create new instance of class " + permissionClass.getName() + " using the following argument(s) " + this.arrayToString(argValues) + ", line nr " + lineNr, (Throwable)e);
    }

    protected final String arrayToString(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length < 1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(array.length * 12);
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    protected void notifyPermission(int lineNr, Class<? extends Permission> permissionClass, Class<?>[] args) {
        log.debug("No constructor found matching argument(s) " + this.arrayToString(args) + " for class " + permissionClass.getName() + ", line nr " + lineNr);
    }

    protected void skipPermission(int lineNr, Class<?> permissionClass) {
        if (permissionClass == null) {
            log.error("Missing permission class at line " + lineNr);
        } else if (Permission.class.isAssignableFrom(permissionClass)) {
            log.error("No valid constructor found for class " + permissionClass.getName() + ", line nr " + lineNr);
        } else {
            log.error(permissionClass.getName() + " is not a subclass of " + Permission.class.getName());
        }
    }

    protected void skipEmptyPrincipal(int lineNr, Principal principal) {
        if (log.isDebugEnabled()) {
            log.debug("skipping principal " + principal + ", no permissions found before line nr " + lineNr);
        }
    }

    protected void skipIllegalPrincipal(int lineNr, Principal principal, Set<Permission> permissions) {
        log.error("Illegal principal block detected at line " + lineNr);
    }

    public final boolean isUsingHiveCache() {
        return this.useHiveCache;
    }

    public final void useHiveCache(boolean useCache) {
        this.useHiveCache = useCache;
    }

    public final boolean isCloseInputStreams() {
        return this.closeInputStreams;
    }

    public final void setCloseInputStreams(boolean closeInputStreams) {
        this.closeInputStreams = closeInputStreams;
    }

    protected final ActionFactory getActionFactory() {
        return this.actionFactory;
    }
}

