/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ManyToManyMap<L, R> {
    private final Map<L, Set<R>> lToRMappings;
    private final Map<R, Set<L>> rToLMappings;

    public ManyToManyMap() {
        this.lToRMappings = new HashMap<L, Set<R>>();
        this.rToLMappings = new HashMap<R, Set<L>>();
    }

    public ManyToManyMap(int initialCapacity) {
        this.lToRMappings = new HashMap<L, Set<R>>(initialCapacity);
        this.rToLMappings = new HashMap<R, Set<L>>(initialCapacity);
    }

    public ManyToManyMap(int initialCapacity, float loadFactor) {
        this.lToRMappings = new HashMap<L, Set<R>>(initialCapacity, loadFactor);
        this.rToLMappings = new HashMap<R, Set<L>>(initialCapacity, loadFactor);
    }

    public void add(L left, R right) {
        if (left == null) {
            throw new NullPointerException("left must not be null.");
        }
        if (right == null) {
            throw new NullPointerException("right must not be null.");
        }
        Set<R> rights = this.lToRMappings.get(left);
        if (rights == null) {
            rights = new HashSet<R>();
        }
        rights.add(right);
        this.lToRMappings.put(left, rights);
        Set<L> lefts = this.rToLMappings.get(right);
        if (lefts == null) {
            lefts = new HashSet<L>();
        }
        lefts.add(left);
        this.rToLMappings.put(right, lefts);
    }

    public boolean remove(L left, R right) {
        Set<R> rights = this.lToRMappings.get(left);
        if (rights != null && rights.remove(right)) {
            if (rights.isEmpty()) {
                this.lToRMappings.remove(left);
            }
            Set<L> lefts = this.rToLMappings.get(right);
            lefts.remove(left);
            if (lefts.isEmpty()) {
                this.rToLMappings.remove(right);
            }
            return true;
        }
        return false;
    }

    public Set<R> removeAllMappingsForLeft(L left) {
        Set<R> rights = this.lToRMappings.remove(left);
        if (rights != null) {
            for (R curRight : rights) {
                Set<L> curLefts = this.rToLMappings.get(curRight);
                curLefts.remove(left);
                if (!curLefts.isEmpty()) continue;
                this.rToLMappings.remove(curRight);
            }
        }
        return rights;
    }

    public Set<L> removeAllMappingsForRight(R right) {
        Set<L> lefts = this.rToLMappings.remove(right);
        if (lefts != null) {
            for (L curLeft : lefts) {
                Set<R> curRights = this.lToRMappings.get(curLeft);
                curRights.remove(right);
                if (!curRights.isEmpty()) continue;
                this.lToRMappings.remove(curLeft);
            }
        }
        return lefts;
    }

    public Set<R> getRight(L left) {
        Set<R> set = this.lToRMappings.get(left);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public Set<L> getLeft(R right) {
        Set<L> set = this.rToLMappings.get(right);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public int size() {
        return this.lToRMappings.size() + this.rToLMappings.size();
    }

    public int numberOfmappingsForLeft(L left) {
        Set<R> set = this.lToRMappings.get(left);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    public int numberOfmappingsForRight(R right) {
        Set<L> set = this.rToLMappings.get(right);
        if (set == null) {
            return 0;
        }
        return set.size();
    }

    public boolean containsLeft(L left) {
        return this.lToRMappings.containsKey(left);
    }

    public boolean containsRight(R right) {
        return this.rToLMappings.containsKey(right);
    }

    public boolean isEmpty() {
        return this.lToRMappings.isEmpty();
    }

    public void clear() {
        this.lToRMappings.clear();
        this.rToLMappings.clear();
    }

    public Iterator<L> leftIterator() {
        return this.lToRMappings.keySet().iterator();
    }

    public Iterator<R> rightIterator() {
        return this.rToLMappings.keySet().iterator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ManyToManyMap) {
            ManyToManyMap other = (ManyToManyMap)obj;
            return this.lToRMappings.equals(other.lToRMappings) && this.rToLMappings.equals(other.lToRMappings);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.rToLMappings.hashCode() ^ 37 * this.lToRMappings.hashCode() + 1979;
    }

    public String toString() {
        return this.lToRMappings.toString() + "\n" + this.rToLMappings.toString();
    }
}

