/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.wicketstuff.security.authentication.LoginException;
import org.wicketstuff.security.hive.authentication.LoginContext;
import org.wicketstuff.security.hive.authentication.Subject;
import org.wicketstuff.security.hive.authentication.WicketSubject;
import org.wicketstuff.security.hive.authorization.Principal;

public final class LoginContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<HashKey> logins = new ArrayList<HashKey>();
    private Map<HashKey, Subject> subjects = new HashMap<HashKey, Subject>();
    private WicketSubject subject = null;
    private HashKey preventsLogin = null;

    public void login(LoginContext context) throws LoginException {
        if (this.preventsLogin != null) {
            throw new LoginException("Additional Logins are not allowed");
        }
        if (context == null) {
            throw new LoginException("Context is required to login.");
        }
        HashKey key = new HashKey(context);
        if (this.subjects.containsKey(key)) {
            throw new LoginException("Already logged in through this context ").setLoginContext((Object)context);
        }
        Subject mySubject = context.login();
        if (mySubject == null) {
            throw new LoginException("Login failed ").setLoginContext((Object)context);
        }
        mySubject.setReadOnly();
        if (key.preventsAdditionalLogins()) {
            this.preventsLogin = key;
        }
        this.subjects.put(key, mySubject);
        this.logins.add(key);
        Collections.sort(this.logins);
        this.subject = new MultiSubject(this.logins, this.subjects);
    }

    public boolean logoff(LoginContext context) {
        if (context == null) {
            return false;
        }
        HashKey key = new HashKey(context);
        Subject removed = this.subjects.remove(key);
        if (removed != null) {
            if (this.preventsLogin != null && this.preventsLogin.equals(key)) {
                this.preventsLogin = null;
            }
            this.logins.remove(key);
            this.subject = this.logins.isEmpty() ? null : new MultiSubject(this.logins, this.subjects);
            Session.get().dirty();
            context.notifyLogoff(removed);
            return true;
        }
        return false;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int size() {
        return this.logins.size();
    }

    public boolean isModelAuthenticated(IModel<?> model, Component component) {
        return this.subject == null ? false : this.subject.isModelAuthenticated(model, component);
    }

    public boolean isComponentAuthenticated(Component component) {
        return this.subject == null ? false : this.subject.isComponentAuthenticated(component);
    }

    public boolean isClassAuthenticated(Class<?> clazz) {
        return this.subject == null ? false : this.subject.isClassAuthenticated(clazz);
    }

    private static final class HashKey
    implements Serializable,
    Comparable<HashKey> {
        private static final long serialVersionUID = 1L;
        private final int contextHash;
        private final boolean preventsAdditionalLogin;
        private int sortOrder;
        private String toStringCache;

        public HashKey(LoginContext context) {
            this.contextHash = context.hashCode();
            this.preventsAdditionalLogin = context.preventsAdditionalLogins();
            this.sortOrder = context.getSortOrder();
            this.toStringCache = new AppendingStringBuffer(25).append("HashKey: ").append(this.contextHash).append(", sortOrder ").append(this.sortOrder).toString();
        }

        public String toString() {
            return this.toStringCache;
        }

        @Override
        public int compareTo(HashKey arg) {
            return this.sortOrder - arg.sortOrder;
        }

        public boolean preventsAdditionalLogins() {
            return this.preventsAdditionalLogin;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.contextHash;
            result = 31 * result + (this.preventsAdditionalLogin ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKey other = (HashKey)obj;
            if (this.contextHash != other.contextHash) {
                return false;
            }
            return this.preventsAdditionalLogin == other.preventsAdditionalLogin;
        }
    }

    private static final class MultiSubject
    implements WicketSubject {
        private static final long serialVersionUID = 1L;
        private Set<Principal> principals;
        private Set<Principal> readOnlyPrincipals;
        private final List<HashKey> keys;
        private final Map<HashKey, Subject> mySubjects;
        private transient String toStringCache = null;

        public MultiSubject(List<HashKey> keys, Map<HashKey, Subject> values) {
            this.keys = keys;
            this.mySubjects = values;
            this.principals = new HashSet<Principal>(100);
            for (Subject curSubject : values.values()) {
                this.principals.addAll(curSubject.getPrincipals());
            }
            this.readOnlyPrincipals = Collections.unmodifiableSet(this.principals);
        }

        public Set<Principal> getPrincipals() {
            return this.readOnlyPrincipals;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setReadOnly() {
        }

        @Override
        public boolean isModelAuthenticated(IModel<?> model, Component component) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = this.keys.get(i);
                Subject subj = this.mySubjects.get(ctx);
                if (subj instanceof WicketSubject) {
                    if (!((WicketSubject)subj).isModelAuthenticated(model, component)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isComponentAuthenticated(Component component) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = this.keys.get(i);
                Subject subj = this.mySubjects.get(ctx);
                if (subj instanceof WicketSubject) {
                    if (!((WicketSubject)subj).isComponentAuthenticated(component)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isClassAuthenticated(Class<?> clazz) {
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = this.keys.get(i);
                Subject subj = this.mySubjects.get(ctx);
                if (subj instanceof WicketSubject) {
                    if (!((WicketSubject)subj).isClassAuthenticated(clazz)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(10 + this.mySubjects.size() * 25);
            buffer.append("Subjects[");
            boolean comma = false;
            HashKey ctx = null;
            for (int i = 0; i < this.keys.size(); ++i) {
                ctx = this.keys.get(i);
                buffer.append((Object)ctx).append(" = ").append((Object)this.mySubjects.get(ctx));
                if (comma) {
                    buffer.append(", ");
                    continue;
                }
                comma = true;
            }
            buffer.append("]");
            this.toStringCache = buffer.toString();
            return this.toStringCache;
        }
    }
}

