/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.hive.authorization.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.wicketstuff.security.actions.Inherit;
import org.wicketstuff.security.actions.WaspAction;
import org.wicketstuff.security.components.SecureComponentHelper;
import org.wicketstuff.security.hive.authorization.Permission;
import org.wicketstuff.security.hive.authorization.permissions.ActionPermission;

public class ComponentPermission
extends ActionPermission {
    private static final long serialVersionUID = 8950870313751454034L;
    private final List<String[]> parents;
    private final String[] path = this.getName().split(":");

    public ComponentPermission(Component component, WaspAction action) {
        super(SecureComponentHelper.alias((Component)component), action);
        String[] aliasses = SecureComponentHelper.containerAliasses((Component)component);
        if (aliasses != null && aliasses.length > 0) {
            this.parents = new ArrayList<String[]>(aliasses.length);
            for (int i = 0; i < aliasses.length; ++i) {
                this.parents.add(aliasses[i].split(":"));
            }
        } else {
            this.parents = Collections.emptyList();
        }
    }

    public ComponentPermission(String componentAlias, WaspAction actions) {
        super(componentAlias, actions);
        this.parents = Collections.emptyList();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof ComponentPermission) {
            ComponentPermission other = (ComponentPermission)permission;
            if (this.getAction().implies(this.getAction().getActionFactory().getAction(Inherit.class))) {
                return this.getAction().implies(other.getAction()) && (this.implies(other.path, this.path) || this.impliesHierarchy(other));
            }
            return this.getAction().implies(other.getAction()) && this.equals(other.path, this.path);
        }
        return false;
    }

    private boolean impliesHierarchy(ComponentPermission other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < other.parents.size(); ++i) {
            if (!this.implies(this.path, other.parents.get(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean equals(String[] path1, String[] path2) {
        if (path1.length != path2.length) {
            return false;
        }
        for (int count = 0; count < path1.length; ++count) {
            if (path1[count].equals(path2[count])) continue;
            return false;
        }
        return true;
    }

    protected boolean implies(String[] path1, String[] path2) {
        int i = 0;
        for (int j = 0; i < path1.length && j < path2.length; ++j) {
            if (path1[i].equals(path2[j])) {
                ++i;
                continue;
            }
            if (i <= 0) continue;
            return false;
        }
        return path1.length == i;
    }
}

