/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze;

import org.wicketstuff.pageserializer.common.analyze.IObjectLabelizer;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTreeProcessor;
import org.wicketstuff.pageserializer.common.analyze.ObjectTreeTracker;
import org.wicketstuff.pageserializer.common.listener.ThreadLocalContextSerializationListener;

public class AnalyzingSerializationListener
extends ThreadLocalContextSerializationListener<ObjectTreeTracker> {
    private final IObjectLabelizer labelizer;
    private final ISerializedObjectTreeProcessor treeProcessor;

    public AnalyzingSerializationListener(IObjectLabelizer labelizer, ISerializedObjectTreeProcessor treeProcessor) {
        this.labelizer = labelizer;
        this.treeProcessor = treeProcessor;
    }

    @Override
    protected ObjectTreeTracker createContext(Object object) {
        return new ObjectTreeTracker(this.labelizer, object);
    }

    @Override
    public void begin(ObjectTreeTracker treeTracker, Object object) {
    }

    @Override
    public void before(ObjectTreeTracker treeTracker, int position, Object object) {
        if (object != null) {
            treeTracker.newItem(position, object);
        }
    }

    @Override
    public void after(ObjectTreeTracker treeTracker, int position, Object object) {
        if (object != null) {
            treeTracker.closeItem(position, object);
        }
    }

    @Override
    public void end(ObjectTreeTracker treeTracker, Object object, Exception exception) {
        if (exception == null) {
            this.treeProcessor.process(treeTracker.end(object));
        }
    }
}

