/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze;

import org.wicketstuff.pageserializer.common.analyze.IObjectLabelizer;

public class NativeTypesAsLabel
implements IObjectLabelizer {
    private final IObjectLabelizer fallback;

    public NativeTypesAsLabel(IObjectLabelizer fallback) {
        this.fallback = fallback;
    }

    @Override
    public String labelFor(Object object) {
        if (object instanceof String) {
            String asString = (String)object;
            if (asString.length() > 4) {
                return "\"" + asString.substring(0, 4) + "...\"";
            }
            return "\"" + asString + "\"";
        }
        if (object instanceof Integer) {
            Integer asInteger = (Integer)object;
            if (asInteger == Integer.MAX_VALUE) {
                return "=MAX";
            }
            if (asInteger == Integer.MIN_VALUE) {
                return "=MIN";
            }
            return "=" + object;
        }
        return this.fallback.labelFor(object);
    }
}

