/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wicketstuff.pageserializer.common.analyze.IObjectLabelizer;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ImmutableTree;
import org.wicketstuff.pageserializer.common.analyze.ObjectId;
import org.wicketstuff.pageserializer.common.analyze.ObjectIdFactory;

class ObjectTreeTracker {
    ObjectIdFactory objectIdFactory = new ObjectIdFactory();
    int lastPosition = 0;
    private final IObjectLabelizer labelizer;
    private Item currentItem;

    public ObjectTreeTracker(IObjectLabelizer labelizer, Object root) {
        this.labelizer = labelizer;
        this.currentItem = new Item(new ItemKey(this.objectIdFactory.idFor(root), root.getClass(), labelizer.labelFor(root)));
    }

    public void newItem(int position, Object object) {
        int diff = this.updatePositionAndCalculateDiff(position);
        this.currentItem = this.currentItem.newItem(diff, new ItemKey(this.objectIdFactory.idFor(object), object.getClass(), this.labelizer.labelFor(object)));
    }

    public void closeItem(int position, Object object) {
        int diff = this.updatePositionAndCalculateDiff(position);
        this.currentItem = this.currentItem.closeItem(diff, new ItemKey(this.objectIdFactory.idFor(object), object.getClass(), this.labelizer.labelFor(object)));
    }

    private int updatePositionAndCalculateDiff(int position) {
        int diff = position - this.lastPosition;
        this.lastPosition = position;
        return diff;
    }

    private ObjectId idFor(Object object) {
        return null;
    }

    public ISerializedObjectTree end(Object object) {
        return ObjectTreeTracker.asImmutableTree(this.stripRootNode());
    }

    private Item stripRootNode() {
        return this.currentItem.children().iterator().next();
    }

    private static List<? extends ISerializedObjectTree> cloneList(Collection<Item> source) {
        ArrayList<ImmutableTree> lchildren = new ArrayList<ImmutableTree>();
        for (Item child : source) {
            lchildren.add(ObjectTreeTracker.asImmutableTree(child));
        }
        return lchildren;
    }

    private static ImmutableTree asImmutableTree(Item child) {
        return new ImmutableTree(child.id(), child.type(), child.label(), child.size(), ObjectTreeTracker.cloneList(child.children()));
    }

    static class ItemKey {
        final ObjectId id;
        final Class<?> type;
        final String label;

        public ItemKey(ObjectId id, Class<?> type, String label) {
            this.id = id;
            this.type = type;
            this.label = label;
        }

        public ObjectId id() {
            return this.id;
        }

        public Class<?> type() {
            return this.type;
        }

        public String label() {
            return this.label;
        }

        public String toString() {
            return "Key(" + this.type + "#" + this.id + "," + this.label + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ItemKey other = (ItemKey)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }

    static class Item {
        private final ItemKey key;
        Map<ItemKey, Item> children = new LinkedHashMap<ItemKey, Item>();
        int size = 0;
        Item parent = null;

        public Item(ItemKey key) {
            this.key = key;
        }

        public ObjectId id() {
            return this.key.id();
        }

        public Item newItem(int diff, ItemKey key) {
            this.size += diff;
            Item item = this.getOrCreateItem(key);
            return item;
        }

        private Item getOrCreateItem(ItemKey key) {
            Item item = this.children.get(key);
            if (item == null) {
                item = new Item(this, key);
                this.children.put(key, item);
            }
            return item;
        }

        public Item closeItem(int diff, ItemKey key) {
            if (!this.key.equals(key)) {
                throw new IllegalArgumentException("key does not match " + this.key + "!=" + key);
            }
            this.size += diff;
            return this.parent;
        }

        private Item(Item parent, ItemKey key) {
            this(key);
            this.parent = parent;
        }

        public int size() {
            return this.size;
        }

        public Class<? extends Object> type() {
            return this.key.type();
        }

        public String label() {
            return this.key.label();
        }

        public Collection<Item> children() {
            return this.children.values();
        }
    }
}

