/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;

public final class TreeType
implements Comparable<TreeType> {
    final Class<?> type;
    final List<TreeType> children;

    public TreeType(ISerializedObjectTree tree) {
        this.type = tree.type();
        this.children = TreeType.children(tree.children());
    }

    @Override
    public int compareTo(TreeType o) {
        if (this.equals(o)) {
            return 0;
        }
        int typeResult = this.type.getName().compareTo(o.type.getName());
        if (typeResult != 0) {
            return typeResult;
        }
        int sizeDiff = this.children.size() - o.children.size();
        if (sizeDiff != 0) {
            return sizeDiff > 0 ? 1 : -1;
        }
        int s = this.children.size();
        for (int i = 0; i < s; ++i) {
            int childCompare = this.children.get(i).compareTo(o.children.get(i));
            if (childCompare == 0) continue;
            return childCompare;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.format(sb, 0);
        return sb.toString();
    }

    private void format(StringBuilder sb, int level) {
        this.indent(sb, level);
        sb.append(this.type.getName());
        if (!this.children.isEmpty()) {
            this.indent(sb, level);
            sb.append("{\n");
            for (TreeType c : this.children) {
                c.format(sb, level + 1);
                sb.append(",\n");
            }
            this.indent(sb, level);
            sb.append("}\n");
        }
    }

    private void indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append(" ");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeType other = (TreeType)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    private static List<TreeType> children(List<? extends ISerializedObjectTree> list) {
        ArrayList<TreeType> ret = new ArrayList<TreeType>();
        for (ISerializedObjectTree iSerializedObjectTree : list) {
            ret.add(new TreeType(iSerializedObjectTree));
        }
        Collections.sort(ret);
        return ret;
    }
}

