/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report.d3js;

import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.util.io.Streams;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.report.IReportRenderer;

public class D3DataFileRenderer
implements IReportRenderer {
    static final String TEMPLATE = D3DataFileRenderer.readTemplateFromResource(D3DataFileRenderer.class, "d3js-partition-template.html");

    @Override
    public String render(ISerializedObjectTree tree) {
        JSonBuilder sb = new JSonBuilder(new StringBuilder());
        sb.start();
        sb.textAttr("name", "all");
        sb.openArray("children");
        this.render(sb, tree);
        sb.closeArray();
        sb.end(true);
        return TEMPLATE.replace("${DATA}", sb.toString());
    }

    private void render(JSonBuilder sb, ISerializedObjectTree tree) {
        sb.start();
        sb.textAttr("name", this.label(tree));
        sb.attr("size", "" + (tree.size() + tree.childSize()));
        if (!tree.children().isEmpty()) {
            sb.openArray("children");
            for (ISerializedObjectTree iSerializedObjectTree : tree.children()) {
                this.render(sb, iSerializedObjectTree);
            }
            sb.closeArray();
        }
        sb.end();
    }

    private String label(ISerializedObjectTree tree) {
        return (tree.type().isAnonymousClass() ? tree.type().getSuperclass().getName() : tree.type().getName()) + (String)(tree.label() != null ? "(" + tree.label() + ")" : "");
    }

    private static String readTemplateFromResource(Class<?> clazz, String resourceName) {
        InputStream resourceAsStream = clazz.getResourceAsStream(resourceName);
        try {
            String string = Streams.readString((InputStream)resourceAsStream, (CharSequence)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class JSonBuilder {
        private final StringBuilder _sb;
        int indent = 0;

        JSonBuilder(StringBuilder sb) {
            this._sb = sb;
        }

        JSonBuilder openArray(String name) {
            return this.indent().label(name).colon().raw("[\n");
        }

        JSonBuilder closeArray() {
            return this.indent().raw("]\n");
        }

        JSonBuilder start() {
            this.indent().raw("{\n");
            ++this.indent;
            return this;
        }

        JSonBuilder end() {
            return this.end(false);
        }

        JSonBuilder end(boolean lastOne) {
            --this.indent;
            if (lastOne) {
                this.indent().raw("}\n");
            } else {
                this.indent().raw("},\n");
            }
            return this;
        }

        JSonBuilder textAttr(String name, String value) {
            return this.indent().label(name).colon().label(value).raw(",\n");
        }

        JSonBuilder attr(String name, String value) {
            return this.indent().label(name).colon().raw(value).raw(",\n");
        }

        JSonBuilder colon() {
            this._sb.append(": ");
            return this;
        }

        JSonBuilder raw(String text) {
            this._sb.append(text);
            return this;
        }

        JSonBuilder label(String name) {
            this._sb.append("\"").append(name).append("\"");
            return this;
        }

        JSonBuilder indent() {
            for (int i = 0; i < this.indent; ++i) {
                this._sb.append("  ");
            }
            return this;
        }

        public String toString() {
            return this._sb.toString();
        }
    }
}

