/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.kryo;

import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggingKryo
extends KryoReflectionFactorySupport {
    private static final Logger LOG = LoggerFactory.getLogger(DebuggingKryo.class);
    private final List<Class<?>> blackList = new ArrayList();

    public DebuggingKryo blacklist(Class<?> ... classes) {
        Args.notNull(classes, (String)"classes");
        for (Class<?> cls : classes) {
            this.blackList.add(cls);
        }
        return this;
    }

    public void writeClassAndObject(ByteBuffer buffer, Object object) {
        if (object != null) {
            Class<?> target = object.getClass();
            for (Class<?> cls : this.blackList) {
                if (!cls.isAssignableFrom(target)) continue;
                throw new IllegalArgumentException("Should not serialize class with type: " + cls.getName());
            }
        }
        super.writeClassAndObject(buffer, object);
        if (object != null) {
            LOG.error("Wrote '{}' bytes for object: '{}'", (Object)buffer.position(), object.getClass());
        }
    }
}

