/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.ClassSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.CurrencySerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import de.javakaffee.kryoserializers.StringBufferSerializer;
import de.javakaffee.kryoserializers.StringBuilderSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.kryoserializers.cglib.CGLibProxySerializer;
import java.lang.reflect.InvocationHandler;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.pageserializer.kryo.WicketChildListSerializer;

public class KryoSerializer
implements ISerializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    private static final Bytes DEFAULT_BUFFER_SIZE = Bytes.megabytes((long)10L);
    private final Bytes bufferSize;
    private final Kryo kryo;

    public KryoSerializer() {
        this(DEFAULT_BUFFER_SIZE);
    }

    public KryoSerializer(Bytes bufferSize) {
        this.bufferSize = (Bytes)Args.notNull((Object)bufferSize, (String)"bufferSize");
        LOG.debug("Buffer size: '{}'", (Object)bufferSize);
        this.kryo = this.createKryo();
        this.internalInit(this.kryo);
    }

    protected Kryo createKryo() {
        return new KryoReflectionFactorySupport();
    }

    public byte[] serialize(Object object) {
        byte[] data;
        LOG.debug("Going to serialize: '{}'", object);
        ByteBuffer buffer = this.getBuffer(object);
        this.kryo.writeClassAndObject(buffer, object);
        if (buffer.hasArray()) {
            data = new byte[buffer.position()];
            buffer.flip();
            buffer.get(data);
        } else {
            LOG.error("Kryo wasn't able to serialize: '{}'", object);
            data = null;
        }
        buffer.clear();
        buffer = null;
        System.runFinalization();
        return data;
    }

    public Object deserialize(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        Object object = this.kryo.readClassAndObject(buffer);
        LOG.debug("Deserialized: '{}'", object);
        buffer.clear();
        buffer = null;
        System.runFinalization();
        return object;
    }

    protected ByteBuffer getBuffer(Object target) {
        return ByteBuffer.allocate((int)this.bufferSize.bytes());
    }

    private void internalInit(Kryo kryo) {
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer(kryo));
        kryo.register(Class.class, (Serializer)new ClassSerializer(kryo));
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer(kryo));
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer(kryo));
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer(kryo));
        kryo.register(Currency.class, (Serializer)new CurrencySerializer(kryo));
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer(kryo));
        kryo.register(StringBuffer.class, (Serializer)new StringBufferSerializer(kryo));
        kryo.register(StringBuilder.class, (Serializer)new StringBuilderSerializer(kryo));
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.register(CGLibProxySerializer.CGLibProxyMarker.class, (Serializer)new CGLibProxySerializer(kryo));
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer(kryo));
        kryo.register(WicketChildListSerializer.CLASS, (Serializer)new WicketChildListSerializer(kryo));
        kryo.setRegistrationOptional(true);
        kryo.register(Panel.class);
        kryo.register(WebPage.class);
        kryo.register(WebMarkupContainer.class);
        kryo.register(Link.class);
        kryo.register(Label.class);
        kryo.register(ListView.class);
        this.init(kryo);
    }

    protected void init(Kryo kryo) {
    }
}

